import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import BaseConstants from "../../base/BaseConstants";
import DATAMIGRATION from "../base/DATAMIGRATION";

export default class DataMigrationNodeUtil {

    static reloadTableCollectionHeight(xmlEntity: IXmlEntity): void {//自动计算表集合的高度
        let tagMigration = xmlEntity.getTagRoot();
        var  nodes = tagMigration.getChildren();
        var nodeSourceColl =  <ITagNode>nodes[0]; //源表集合
        var nodeTargetColl =  <ITagNode>nodes[1]; //目标表表集合
        this.reloadTableHeight(nodeSourceColl);
        this.reloadTableHeight(nodeTargetColl);
    }

    static reloadTableHeight(node: ITagNode): void {
        let rowSize = 2
          let children = node.getChildren();
          rowSize = rowSize+ children.length*2
        for (let child of children) {
            let table = <ITagNode>child;
            let length = table.getChildren().length;
            rowSize = rowSize+length
        }
        let attributeValue = node.getAttributeValue(BaseConstants.ATTR_Height,"0");
        if (Number(attributeValue)<rowSize*DATAMIGRATION.D_ROW_HEIGHT){
            node.setAttributeValue(BaseConstants.ATTR_Height,(rowSize*DATAMIGRATION.D_ROW_HEIGHT).toString())
        }
    }


}