import AbstactDataMigrationOptState from "./AbstactDataMigrationOptState";
import DataMigrationOptStateDelegate from "./DataMigrationOptStateDelegate";
import {FieldView} from "../view/FieldView";
import DomUtil from "../../../common/dom/DomUtil";
import DataMigrationConstants from "../base/DataMigrationConstants";
import BaseConstants from "../../base/BaseConstants";
import DataMigrationUtil from "../base/DataMigrationUtil";
import DomElement from "../../../common/dom/element/DomElement";
import {CommonConstant} from "../../datamap/base/CommonConstant";


export default class NewLinkState extends AbstactDataMigrationOptState {
    private fromTag?: FieldView;

    private toNodeKey?: FieldView


    constructor(delegate: DataMigrationOptStateDelegate) {
        super(delegate);

    }

    mousedown(e: MouseEvent): void {
        let view = this.findFieldView(e);
        if (!view) return;
    }

    setFromNode(e: MouseEvent, x: number, y: number) {
        this.ensureShadowLink().setFromNode({x: x, y: y, width: 4, height: 4});
    }

    mousemove(e: MouseEvent): void {
        let target = <HTMLElement>e.target;
        let currentTarget = new DomElement(<HTMLElement> e.currentTarget).getEl();
        if (this.fromTag) {
            let view = this.findFieldView(e);
            if (view) {
                let node = view.getTagNode();
                if (node.getTagName() == DataMigrationConstants.NODE_TargetField) {
                    let tarPoint = this.getView().getTarPoint();
                    let fieldKey = node.getAttributeValue(DataMigrationConstants.NODE_FieldKey);
                    let tableKey = node.getParent()!.getAttributeValue(BaseConstants.ATTR_TableKey);
                    let tarPos = tarPoint.get(tableKey + "_" + fieldKey);
                    this.ensureShadowLink().drawShadowToLink({
                        x: tarPos!.getOffsetLeft(),
                        y: tarPos!.getOffsetTop() - 30,
                        width: 4,
                        height: 4
                    });
                } else {//选择到了源表中
                    let offsetBodyPosition = DomUtil.offsetBodyPosition(currentTarget);
                    this.ensureShadowLink().drawShadowToLink({
                        x: e.x - offsetBodyPosition.offsetBodyLeft,
                        y: e.y - offsetBodyPosition.offsetBodyTop,
                        width: 4,
                        height: 4
                    });
                }
            } else {
                let offsetBodyPosition = DomUtil.offsetBodyPosition(currentTarget);
                this.ensureShadowLink().drawShadowToLink({
                    x: e.x - offsetBodyPosition.offsetBodyLeft,
                    y: e.y - offsetBodyPosition.offsetBodyTop,
                    width: 4,
                    height: 4
                });
            }
        }/*else if(target.className != "addline-button"){
            this.getDelegate().setNormalState();
        }*/
    }

    mouseup(e: MouseEvent): void {
        let view = this.findFieldView(e);
        if (!view) {
            this.reset();
            return;
        }
        let node = view.getTagNode();
        if (!this.toNodeKey && node) {
            this.toNodeKey = view;
        }
        if (this.fromTag && this.toNodeKey) {
            let fromFieldType = this.fromTag.getFieldType();
            let tarFieldType = this.toNodeKey.getFieldType();

            let root = this.fromTag.getTagNode().getParent()!.getParent()!.getParent();
            if(root!.hasAttribute(CommonConstant.ATTR_Extend)){
                let fromTag = this.fromTag.getTagNode();
                let toTag = this.toNodeKey.getTagNode();
                let extendSourceToTargetLinks = this.getView().getExtendSourceToTargetLinks();
                if(extendSourceToTargetLinks &&  extendSourceToTargetLinks.length > 0){
                    let fieldKey;
                    if(fromTag.hasAttribute(CommonConstant.NODE_Definition)){
                        fieldKey = fromTag.getAttributeValue(CommonConstant.NODE_Definition);
                    }else{
                        fieldKey = fromTag.getAttributeValue(CommonConstant.S_Key);
                    }
                    let sourceTableKey = fromTag.getParent()!.getAttributeValue(CommonConstant.S_Key);
                    let targetFieldKey = toTag.getAttributeValue(CommonConstant.ATTR_FieldKey);
                    let targetTableKey = toTag.getParent()!.getAttributeValue(CommonConstant.ATTR_TableKey);
                    let link = sourceTableKey + "*" + fieldKey + "--" + targetTableKey + "*" + targetFieldKey;
                    if(extendSourceToTargetLinks.indexOf(link) > -1){
                        this.reset();
                        // @ts-ignore
                        layui.layer.msg("检测到关联数据迁移已存在此映射边，不允许重复添加！", {icon: 5, time:2000});
                        return;
                    }
                }
            }
            if (fromFieldType == "") {
                this.getView().doNewLinkCmd(this.getView(), this.fromTag.getTagNode(), this.toNodeKey.getTagNode());
            } else {
                if (fromFieldType == tarFieldType && fromFieldType != '') {
                    this.getView().doNewLinkCmd(this.getView(), this.fromTag.getTagNode(), this.toNodeKey.getTagNode());
                } else {
                    this.reset();
                    // @ts-ignore
                    layui.layer.msg("数据类型不匹配，不支持此操作!", {icon: 5, time: 5000,})
                    //  throw new Error('数据类型不匹配，不支持此操作!');
                }
            }

        }
        this.reset();
    }

    reset(): void {
        super.reset();
        this.fromTag = undefined;
        this.toNodeKey = undefined;
        //this.getDelegate().reset();
    }

    setFromEl(view: FieldView, e: MouseEvent): void {
        let node = view.getTagNode();
        if (node.getTagName() == DataMigrationConstants.NODE_SourceField) {
            let srcPoint = this.getView().getSrcPoint();
            let showText = DataMigrationUtil.getSourceFieldShowText(node);
            let tableKey = node.getParent()!.getAttributeValue(DataMigrationConstants.Attr_Key);
            let scrPos = srcPoint.get(tableKey + "_" + showText);
            this.getView().setSelectFieldView(view);
            if (!this.fromTag && node) {
                this.fromTag = view;
                this.setFromNode(e, scrPos!.getOffsetLeft(), scrPos!.getOffsetTop() - 30);
                return;
            }
        }
    }
}