import AbstactDataMigrationOptState from "./AbstactDataMigrationOptState";
import {FieldView} from "../view/FieldView";
import DataMigrationConstants from "../base/DataMigrationConstants";
import DataMigrationOptStateDelegate from "./DataMigrationOptStateDelegate";
import BaseConstants from "../../base/BaseConstants";
import DomUtil from "../../../common/dom/DomUtil";

/**
 * 拖动table的状态属性类
 */
export default class MoveTableState  extends AbstactDataMigrationOptState {

    // 鼠标点击的记录
    private ele?: MouseEvent;

    private tableHeadView?: FieldView;

    // 虚拟框
    private moveSelected:any

    private toolbarHeight:number = 32;//toolbar的高度

    constructor(delegate: DataMigrationOptStateDelegate) {
        super(delegate);
    }

    init(value: FieldView, e:MouseEvent, isMoving:boolean) {
        this.tableHeadView = value;
        this.ele = e;
        // 做一个虚拟框标示新的位置
        let tagNode = value.getTagNode();
        let width = tagNode.getAttributeValue("Width");
        let height = tagNode.getAttributeValue("Height");
        $('#tdMoveSelected').remove();
        this.moveSelected = $('<div id="tdMoveSelected" style="position: relative;"></div>').hide();
        this.moveSelected.css('cursor', 'move');
        this.moveSelected.css('border', '1px dashed black');
        this.moveSelected.css({width: width, height:height});
        this.moveSelected.appendTo($(this.getView().getEl()).find('svg').parent());
        let self = this;
        this.moveSelected.mousemove(function(e1: MouseEvent) {
            self.mousemove(e1);
        })
        this.moveSelected.mouseup(function(e1: MouseEvent) {
            self.mouseup(e1);
        })
    }

    reset(){
        this.tableHeadView = undefined
        this.ele = undefined
        this.moveSelected.remove()
        this.moveSelected = undefined
    }

    mousedown(e: MouseEvent): void {
        let view = this.findFieldView(e);
        if (!view) return;
    }

    mousemove(e: MouseEvent): void {
        if(this.ele){

            let mousedownX = this.ele.clientX, // 鼠标点击的位置
                mousedownY = this.ele.clientY;
            let tagNode = this.tableHeadView!.getTagNode();
            let tableX = +tagNode.getAttributeValue("X"),
                tableY = +tagNode.getAttributeValue("Y"); // + 转成number 表格的偏移量
            let relativeX = Math.abs(mousedownX - tableX), // 鼠标与表格的相对位置
                relativeY = Math.abs(mousedownY - tableY);
            this.moveSelected.css({left: Math.abs(e.clientX - relativeX), top: Math.abs(e.clientY - relativeY)}).show();
        }
    }

    mouseup(e: MouseEvent) {
        // 确认位置 执行更改tagnode的x y
        let moveSelected = this.moveSelected;
        let relativeLeft = Math.abs(moveSelected.offset().left - moveSelected.parent().offset().left),
            relativeTop = Math.abs(moveSelected.offset().top - moveSelected.parent().offset().top);

        this.getView().doMoveTableCmd(this.getView(), this.tableHeadView!.getTagNode(),
            relativeLeft , relativeTop);
        this.reset();
        this.getDelegate().setNormalState();
    }


}