import AbstactDataMigrationOptState from "./AbstactDataMigrationOptState";
import {FieldView} from "../view/FieldView";
import DataMigrationConstants from "../base/DataMigrationConstants";
import DataMigrationOptStateDelegate from "./DataMigrationOptStateDelegate";
import BaseConstants from "../../base/BaseConstants";
import DomUtil from "../../../common/dom/DomUtil";

/**
 * 拖动字段cell的状态类
 */
export default class MoveFieldState extends AbstactDataMigrationOptState {
    private fromTag?: FieldView;

    constructor(delegate: DataMigrationOptStateDelegate) {
        super(delegate);
    }
    mousedown(e: MouseEvent): void {
        let view = this.findFieldView(e);
        if (!view)return;
    }

    mousemove(e: MouseEvent): void {

        if (e.button == 0 && e.buttons == 1) {//按下并且移动
            if (this.fromTag) {
                let view = this.findFieldView(e);
                if (view){
                    let node = view.getTagNode();
                    if (node.getTagName() ==DataMigrationConstants.NODE_SourceField){
                        if (this.fromTag.getTagNode() != view.getTagNode()) {

                        }
                    }
                }else {

                }
            }
        }
        //
    }

    mouseup(e: MouseEvent) {

        if (this.fromTag) {
            let view = this.findFieldView(e);
            if (view){
                if (this.fromTag.getTagNode() != view.getTagNode()) {
                    let fromNode = this.fromTag.getTagNode();
                    let toNode = view.getTagNode();
                    if(fromNode.getParent()!.getTagName() == DataMigrationConstants.NODE_SourceTable){
                        if(fromNode.getParent()!.getAttributeValue(DataMigrationConstants.Attr_Key) ==
                            toNode.getParent()!.getAttributeValue(DataMigrationConstants.Attr_Key)) { // 同一张表调换
                            // 更新
                            this.getView().doMoveFieldCmd(this.getView(),fromNode,toNode);
                        }
                    }else{
                        if(fromNode.getParent()!.getAttributeValue(BaseConstants.ATTR_TableKey) ==
                            toNode.getParent()!.getAttributeValue(BaseConstants.ATTR_TableKey)) { // 同一张表调换
                            // 更新
                            this.getView().doMoveFieldCmd(this.getView(),fromNode,toNode);
                        }
                    }

                }
            }
        }
        this.getDelegate().setNormalState();

    }

    setFromEl(view: FieldView): void {
        let node = view.getTagNode();
        this.getView().setSelectFieldView(view);
        if (!this.fromTag && node) {
            this.fromTag = view;
            return;
        }
    }


}