import AbstactDataMigrationOptState from "./AbstactDataMigrationOptState";
import ITagNode from "../../../common/xml/node/ITagNode";
import {FieldView} from "../view/FieldView";
import NewLinkState from "./NewLinkState";
import MoveFieldState from "./MoveFieldState";
import DataMigrationConstants from "../base/DataMigrationConstants";
import MoveTableState from "./MoveTableState";
import SizeInfo from "../../../common/struct/SizeInfo";


export default class FieldOptState extends AbstactDataMigrationOptState {

    private fromTag?: FieldView;

    private toNodeKey?: ITagNode;

    private view?: FieldView;

    private el?: any;
    private startX = 0;
    private startY = 0;

    mousedown(e: MouseEvent): void {
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.el = e
        var view = this.findFieldView(e);
        if (!view) return;

        let elHTMLElement = <HTMLElement>e.target;
        if (elHTMLElement.nodeName == "SPAN") {
            elHTMLElement = <HTMLElement>elHTMLElement.parentElement;
        }
        let offsetWidth = elHTMLElement.offsetWidth;
        let offsetX = e.offsetX;

        this.MouseIcon(view, elHTMLElement, offsetX, offsetWidth);

        let htmlElements = $(view.getEl());
        let attributeValue = view.getTagNode().getAttributeValue("Type", "Field");
        let node = view.getTagNode();
        this.view = view
        if (htmlElements.parent().hasClass("fieldselected") && htmlElements.parent().hasClass("fieldCell_pointer")) {//代表第二次点击 字段的第二次点击可以修改
            if (attributeValue != "Field") {
                let selectSourceView = this.getView().getSelectSourceView();
                console.log("不是\"Varchar\"")
                view.setStyle("display", "none");
                var height = SizeInfo.valueOfPX(Number(htmlElements.parent().height()));
                var width = SizeInfo.valueOfPX(Number(htmlElements.parent().width()));
                //支持修改
                let textEditor = view.getTextEditor();
                textEditor.setStyle("display", "block");
                view.getImageDomElement().setStyle("display", "none");
                textEditor.setStyle("width", width);
                textEditor.setStyle("height", "100%");
                textEditor.setStyle("min-height", height);
                textEditor.setStyle("disabled", "true");
                setTimeout(function () {
                    var text = view!.getCaption();
                    textEditor.setValue(text);
                    textEditor.getEl().focus();
                }, 10);
            }
        } else {
            if ((elHTMLElement.nodeName == "BUTTON" && elHTMLElement.className == "add-button") || (elHTMLElement.nodeName == "IMG" && elHTMLElement.className == "delete-button-field")) {
                this.getDelegate().setNormalState();
            } else {
                let selectionModel = this.getView().getXmlEntity().getSelectionModel();
                selectionModel.select(node);
                this.getView().setSelectFieldView(view);
            }

        }
    }


    mousemove(e: MouseEvent): void {
        let ele = <MouseEvent>this.el;
        let elHTMLElement = <HTMLElement>e.target;

        if (elHTMLElement.nodeName == "SPAN") {
            elHTMLElement = <HTMLElement>elHTMLElement.parentElement;
        }
        let offsetWidth = elHTMLElement.offsetWidth;
        let offsetX = e.offsetX;
        let findField = this.findFieldView(e);
        this.MouseIcon(findField, elHTMLElement, offsetX, offsetWidth);
        if (e.button == 0 && e.buttons == 1 && this.view) {//按下并且移动

            if (findField) {//在table内
                if (Math.abs(this.startX - e.clientX) > 1 || Math.abs(this.startY - e.clientY) > 1){
                    findField.getImageDomElement()?.setStyle("display", "none");
                }
                // 拖动的是头
                if ((findField.getTagNode().getTagName() == DataMigrationConstants.NODE_SourceTableCollection ||
                    findField.getTagNode().getTagName() == DataMigrationConstants.NODE_TargetTableCollection)
                    && (Math.abs(this.startX - e.clientX) > 10 || Math.abs(this.startY - e.clientY) > 10)
                    && findField?.getTagNode() == this.view.getTagNode()) {
                    let newMoveTableState = new MoveTableState(this.getDelegate());
                    newMoveTableState.init(findField, ele, true);
                    this.getDelegate().setMoveTableState(newMoveTableState);
                } else if (findField.getTagNode() != this.view.getTagNode()) { // 拖动离开了字段
                    //改变鼠标样式

                    var newMoveFieldState = new MoveFieldState(this.getDelegate());
                    newMoveFieldState.setFromEl(this.view)
                    this.getDelegate().setMoveFieldState(newMoveFieldState);
                }

            } else {//在table外
                //移出table位置，标识连线
                //改变鼠标样式
                var newLinkState = new NewLinkState(this.getDelegate());
                newLinkState.setFromEl(this.view, ele)
                this.getDelegate().setNewLinkState(newLinkState);
                this.el = undefined
                this.view = undefined
            }

        } else {//普通的移动
            if (!findField) {
                this.getDelegate().setNormalState();
            }
        }
    }

    private MouseIcon(findField: FieldView | undefined, elHTMLElement: HTMLElement, offsetX: number, offsetWidth: number) {
        if (findField && findField!.getTagNode().getTagName() == DataMigrationConstants.NODE_SourceField) {
            const el = $(elHTMLElement);
            el.removeClass("fieldCell_move");
            el.removeClass("fieldCell_crosshair");
            el.removeClass("fieldCell_pointer");
            if (elHTMLElement.nodeName == "TD" && !$(elHTMLElement).hasClass("tablehead")) {
                if ((offsetX >= 0 && offsetX <= 40) || (offsetX <= offsetWidth && offsetX >= offsetWidth - 40)) {
                    if (offsetX >= 0 && offsetX <= 40) {
                        el.addClass("fieldCell_move")
                    } else {
                        el.addClass("fieldCell_crosshair");
                    }
                } else {
                    let attributeValue = findField!.getTagNode().getAttributeValue("Type", "Field");
                    if (attributeValue != "Field") {
                        el.addClass("fieldCell_pointer")
                    } else {
                        el.addClass("fieldCell_move")
                    }
                }
            }
        }
    }

    mouseup(e: MouseEvent): void {
        this.el = undefined
        this.view = undefined
        this.getDelegate().setNormalState();

    }

    reset(): void {
        this.fromTag = undefined;
        this.toNodeKey = undefined;
        this.getDelegate().reset();
    }

}
