import AbstractOptStateDelegate from "../../../common/state/AbstractOptStateDelegate";
import DataMigrationGraphicView from "../view/DataMigrationGraphicView";
import NormalState from "./NormalState";
import NewLinkState from "./NewLinkState";
import FieldOptState from "./FieldOptState";
import MoveFieldState from "./MoveFieldState";
import MoveTableState from "./MoveTableState";
import InputState from "./InputState";

export default class DataMigrationOptStateDelegate extends AbstractOptStateDelegate<DataMigrationGraphicView> {

    private normalState: NormalState;
    private newLinkState: NewLinkState;
    private fieldOptState: FieldOptState;
    private moveFieldState: MoveFieldState;
    private moveTableState: MoveTableState;
    private inputState: InputState;

    constructor(view: DataMigrationGraphicView) {
        super(view);
        this.normalState = new NormalState(this);
        this.newLinkState = new NewLinkState(this);
        this.fieldOptState = new FieldOptState(this);
        this.moveFieldState = new MoveFieldState(this);
        this.moveTableState = new MoveTableState(this);
        this.inputState = new InputState(this);
        this.setInitState(this.normalState);
    }

    setNormalState(): void {
        this.setCurrentState(this.normalState);
    }

    setNewLinkState(newLinkState: NewLinkState): void {
        this.setCurrentState(newLinkState);
    }

    setFieldOptState(): void {
        this.setCurrentState(this.fieldOptState);
    }

    setMoveFieldState(newFieldState: MoveFieldState): void {
        this.setCurrentState(newFieldState);
    }

    setMoveTableState(moveTableState: MoveTableState): void {
        this.setCurrentState(moveTableState);
    }

    setInputState(): void {
        this.setCurrentState(this.inputState);
    }

}