import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import Button from "../../../../common/component/control/Button";
import Label from "../../../../common/component/control/Label";
import DataMigrationConstants from "../../base/DataMigrationConstants";
import ITagNode from "../../../../common/xml/node/ITagNode";
import TagNode from "../../../../common/xml/node/TagNode";
import DataMigrationGraphicView from "../../view/DataMigrationGraphicView";

export class AddButton extends Button {
    private container: ButtonContainer;

    constructor(parentTagNode: ITagNode, dataMigrationGraphicView: DataMigrationGraphicView, type: string) {
        super("+");
        this.addClass("add-button");
        var self = this;
        self.addEventListener('click', (e: MouseEvent) => {
            if (self.getDomElement().getChildCount() > 1) {
                self.getDomElement().removeChild(self.container);
            } else {
                self.getDomElement().addChild(self.container);
                self.container.getEl().focus();
            }
        });

        this.container = new ButtonContainer(parentTagNode, dataMigrationGraphicView, type);
        this.container.addEventListener("blur", (e: any) => {
            var el = e.target;
            setTimeout(function () {
                self.getDomElement().removeChild(self.container);
            }, 1)
        }, true);
    }

    getContainer() {
        return this.container;
    }
}

class ButtonContainer extends AbstractDomElement {
    private width: number = 140;
    private type: string = DataMigrationConstants.Attr_Key;
    private tagType: string = DataMigrationConstants.NODE_SourceField;
    private type_array = [
        new Array("添加Const类型字段", "Const"),
        new Array("添加Formula类型字段", "Formula"),
    ];

    constructor(parentTagNode: ITagNode, dataMigrationGraphicView: DataMigrationGraphicView, type: string) {
        super();
        this.setStyle('position', 'absolute');
        this.setStyle('right', '-3px');
        this.setStyle('z-index', '66666666');
        this.setStyle('display', 'flex');
        this.setStyle('width', this.width + 'px');
        this.setStyle('height', '50px');
        this.setStyle('margin', '5px');
        this.setStyle('flex-direction', 'row');
        this.setStyle('flex-wrap', 'wrap');
        this.setStyle('justify-content', 'left');
        this.setStyle('align-items', 'center');
        this.setStyle('background-color', 'rgb(231, 233, 238)');
        this.setStyle('border', '1px solid');
        this.setAttr("tabindex", "0");
        //迁移目标表不支持公式常量字段
        // if (type == DataMigrationConstants.NODE_TargetTable) {
        //     this.type = DataMigrationConstants.NODE_FieldKey;
        //     this.tagType = DataMigrationConstants.NODE_TargetField;
        // }
        // 遍历数组，添加pick按钮至容器
        for (let type of this.type_array) {
            var label = new Label(type[0]);
            label.addClass("fieldCell");
            label.getEl().setAttribute("value", type[0]);
            label.getEl().setAttribute("name", type[1]);
            var self = <DataMigrationGraphicView>dataMigrationGraphicView;
            if (type[1] == DataMigrationConstants.AddFieldType_Const) {
                label.addEventListener('click', (e: MouseEvent) => {
                    var newfieldTag = new TagNode(this.tagType);
                    parentTagNode.addChild(newfieldTag);
                    if (parentTagNode.find(this.tagType, this.type, DataMigrationConstants.AddFieldType_Const) != null) {
                        let i = 1;
                        while (parentTagNode.find(this.tagType, this.type, DataMigrationConstants.AddFieldType_Const + i) != null) {
                            i++;
                        }
                        newfieldTag.setAttributeValue(this.type, DataMigrationConstants.AddFieldType_Const + i);
                        newfieldTag.setAttributeValue(DataMigrationConstants.NODE_Definition, "请双击单元格修改常量" + i);
                    } else {
                        newfieldTag.setAttributeValue(this.type, DataMigrationConstants.AddFieldType_Const);
                        newfieldTag.setAttributeValue(DataMigrationConstants.NODE_Definition, "请双击单元格修改常量");
                    }

                    newfieldTag.setAttributeValue("Type", DataMigrationConstants.AddFieldType_Const);
                    self.getXmlEntity().update(parentTagNode, false);
                    this.setStyle('display', 'none');
                });
            } else if (type[1] == DataMigrationConstants.AddFieldType_Formula) {
                label.addEventListener('click', (e: MouseEvent) => {
                    var newfieldTag = new TagNode(this.tagType);

                    if (parentTagNode.find(this.tagType, this.type, DataMigrationConstants.AddFieldType_Formula) != null) {
                        let i = 1;
                        while (parentTagNode.find(this.tagType, this.type, DataMigrationConstants.AddFieldType_Formula + i) != null) {
                            i++;
                        }
                        newfieldTag.setAttributeValue(this.type, DataMigrationConstants.AddFieldType_Formula + i);
                        newfieldTag.setAttributeValue(DataMigrationConstants.NODE_Definition, "请双击单元格修改公式" + i);
                    } else {
                        newfieldTag.setAttributeValue(this.type, DataMigrationConstants.AddFieldType_Formula);
                        newfieldTag.setAttributeValue(DataMigrationConstants.NODE_Definition, "请双击单元格修改公式");
                    }

                    newfieldTag.setAttributeValue("Type", DataMigrationConstants.AddFieldType_Formula);
                    parentTagNode.addChild(newfieldTag);
                    self.getXmlEntity().update(parentTagNode, false);
                    this.setStyle('display', 'none');
                });
            }
            this.addChild(label.getDomElement());
        }

    }
}