import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import TagNode from "../../../common/xml/node/TagNode";
import DataMigrationGraphicView from "../view/DataMigrationGraphicView";
import DataMigrationConstants from "../base/DataMigrationConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import {CommonConstant} from "../../datamap/base/CommonConstant";

export default class InputCellCmd implements ICmd {
    private oldXmlEntity?: ITagNode;
    private self: DataMigrationGraphicView;
    private selectNode?: ITagNode;
    private e: any;

    constructor(self: DataMigrationGraphicView, e: any) {
        this.self = self;
        this.e = e;
    }

    do(): boolean {
        var e = this.e;
        var self = this.self;
        var value1 = String($(e.target).val());


        let selectFieldView = self.getSelectFieldView();
        let tagNode = selectFieldView!.getTagNode();
        this.selectNode = tagNode;
        let root = this.self.getXmlEntity().getTagRoot().toXml(true);
        let childs = tagNode.getParent()!.getChildren();
        let fieldKey;
        if (tagNode.hasAttribute(CommonConstant.NODE_Definition)) {
            fieldKey = tagNode.getAttributeValue(CommonConstant.NODE_Definition);
        } else {
            fieldKey = tagNode.getAttributeValue(CommonConstant.S_Key);
        }
        for (let i = 0; i < childs.length; i++) {
            let findTagNode = <ITagNode>childs[i];
            if (findTagNode.getAttributeValue(CommonConstant.S_Key) == fieldKey) {
                findTagNode.setAttributeValue(CommonConstant.S_Key, value1);
            } else if (findTagNode.getAttributeValue(CommonConstant.NODE_Definition) == fieldKey) {
                findTagNode.setAttributeValue(CommonConstant.NODE_Definition, value1);
                findTagNode.setAttributeValue(CommonConstant.S_Key, findTagNode.getAttributeValue(CommonConstant.S_Key, "").replace(fieldKey, value1));
            }
        }
        this.self.getXmlEntity().select(tagNode);
        this.oldXmlEntity = XmlEntity.parseTagNode(root);
        return true;
    }

    undo(): void {
        let root = this.self.getXmlEntity().getTagRoot();
        if(this.oldXmlEntity){
            root.clearChildren();
            let mapChilds =  this.oldXmlEntity.getChildren();
            for (let i = 0; i< mapChilds.length; i++){
                let mapChild = <ITagNode>mapChilds[i];
                root.addChild(mapChild);
            }
            this.self.getXmlEntity().update(root,false);
        }
    }
}