import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import DataMigrationGraphicView from "../view/DataMigrationGraphicView";
import DataMigrationConstants from "../base/DataMigrationConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import {CommonConstant} from "../../datamap/base/CommonConstant";

export default class FieldDelete implements ICmd {
    private oldXmlEntity?: ITagNode;
    private selectFieldViewTagNode?: ITagNode;
    private sefl: DataMigrationGraphicView;
    private selectNodeParentXml?: string;
    private e: any;

    constructor(sefl: DataMigrationGraphicView, e: any) {
        this.sefl = sefl;
        this.e = e;
    }

    do(): boolean {
        var sefl = this.sefl;
        let root = this.sefl.getXmlEntity().getTagRoot();
        let rootXml = root.toXml(true);
        this.oldXmlEntity = XmlEntity.parseTagNode(rootXml);
        let selectFieldView = sefl.getSelectFieldTagNode();
        this.selectFieldViewTagNode = selectFieldView;
        let parent = selectFieldView!.getParent();
        this.selectNodeParentXml = parent!.toXml(true);
        if (parent?.getChildren().length == 1 && (selectFieldView?.getTagName() == "SourceField" || selectFieldView?.getTagName() == "TargetField")) {
            let parent1 = parent!.getParent();
            parent1?.removeChild(parent!.getTagNode());
        } else {
            if(selectFieldView?.getTagName() == "SourceField")
            {
                for (let i = parent!.getChildren().length -1; i >= 0; i--){
                    let field = <ITagNode>parent!.getChildren()[i];
                    if(selectFieldView.hasAttribute(CommonConstant.NODE_Definition)){
                        if(selectFieldView.getAttributeValue(CommonConstant.NODE_Definition) == field.getAttributeValue(CommonConstant.NODE_Definition)
                            || selectFieldView.getAttributeValue(CommonConstant.NODE_Definition) == field.getAttributeValue(CommonConstant.S_Key)){
                            parent?.removeChild(field);
                        }
                    }else{
                        if(selectFieldView.getAttributeValue(CommonConstant.S_Key) == field.getAttributeValue(CommonConstant.S_Key)
                            || selectFieldView.getAttributeValue(CommonConstant.S_Key) == field.getAttributeValue(CommonConstant.NODE_Definition)){
                            parent?.removeChild(field);
                        }
                    }
                    if(!parent?.getChildren() ||  parent?.getChildren().length < 1){
                        let parent1 = parent!.getParent();
                        parent1?.removeChild(parent!.getTagNode());
                    }
                }
            }else{
                parent?.removeChild(selectFieldView!);
            }
            // 如果删除了 target node  需要清除 sourceField中的信息
            if (selectFieldView?.getTagName() == "TargetField") {
                let children = parent!.getParent()!.getParent()!.getChild(DataMigrationConstants.NODE_SourceTableCollection)!.getChildren();
                for (let node of children) {
                    let sourceTable = <ITagNode>node;
                    for (let child of sourceTable.getChildren()) {
                        let sourceField = <ITagNode>child;
                        if (sourceField.getAttributeValue("TargetFieldKey") == selectFieldView?.getAttributeValue("FieldKey") &&
                            sourceField.getAttributeValue("TargetTableKey") == parent?.getAttributeValue("TableKey")) {
                            if(sourceField.hasAttribute(CommonConstant.NODE_Definition)){
                                sourceField.getParent()!.removeChild(sourceField);
                            }
                            else{
                                sourceField.removeAttribute("TargetTableKey");
                                sourceField.removeAttribute("TargetFieldKey");
                            }

                        }
                    }
                }
            }
            // 如果删除了 target 整个表 需要清除 sourceField中的信息
            if (selectFieldView?.getTagName() == "TargetTable") {
                let children = parent!.getParent()!.getChild(DataMigrationConstants.NODE_SourceTableCollection)!.getChildren();
                for (let node of children) {
                    let sourceTable = <ITagNode>node;
                    for (let child of sourceTable.getChildren()) {
                        let sourceField = <ITagNode>child;
                        if (sourceField.getAttributeValue("TargetTableKey") == selectFieldView?.getAttributeValue("TableKey")) {
                            if(sourceField.hasAttribute(CommonConstant.NODE_Definition)){
                                sourceField.getParent()!.removeChild(sourceField);
                            }
                            else{
                                sourceField.removeAttribute("TargetTableKey");
                                sourceField.removeAttribute("TargetFieldKey");
                            }
                        }
                    }
                }
            }
        }
        this.sefl.getXmlEntity().update(root,false);
        return true;
    }

    undo(): void {
        let root = this.sefl.getXmlEntity().getTagRoot();
        if(this.oldXmlEntity){
            root.clearChildren();
            let parent = XmlEntity.parseTagNode(this.selectNodeParentXml!);
            let mapChilds =  this.oldXmlEntity.getChildren();
            for (let i = 0; i< mapChilds.length; i++){
                let mapChild = <ITagNode>mapChilds[i];
                for(let j = 0; j < mapChild.getChildren().length; j++){
                    let table = <ITagNode>mapChild.getChildren()[j];
                    if(table.getTagName() != parent.getTagName()) continue;
                    for (let k = 0; k < table.getChildren().length; k++){
                        let field = <ITagNode>table.getChildren()[k];
                        if(field.getAttributeValue(CommonConstant.S_Key) == this.selectFieldViewTagNode!.getAttributeValue(CommonConstant.S_Key)){
                            this.selectFieldViewTagNode = field;
                            break;
                        }
                    }
                }
                root.addChild(mapChild);
            }
            this.sefl.getXmlEntity().update(root,false);
            this.sefl.setSelectFieldTagNode(this.selectFieldViewTagNode!);
        }

    }
}