import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import TagNode from "../../../common/xml/node/TagNode";
import DataMigrationConstants from "../base/DataMigrationConstants";
import BaseConstants from "../../base/BaseConstants";
import DataMigrationGraphicView from "../view/DataMigrationGraphicView";
import XmlEntity from "../../../common/xml/XmlEntity";
import {CommonConstant} from "../../datamap/base/CommonConstant";


export default class DeleteLinkCmd implements ICmd {

    private dataMigrationGraphicView: DataMigrationGraphicView;
    private parentNode?: ITagNode;
    private newTarNode?: ITagNode;
    private oldTarNode?: ITagNode;

    private tarNode!: ITagNode;


    constructor(dataMigrationGraphicView: DataMigrationGraphicView, tarNode: ITagNode) {
        this.dataMigrationGraphicView = dataMigrationGraphicView;
        this.tarNode = tarNode;
    }

    do(): boolean {

        let node = this.tarNode.toXml(true);
        this.oldTarNode = XmlEntity.parseTagNode(node);
        if(this.tarNode.hasAttribute(CommonConstant.NODE_Definition)){
            this.parentNode = this.tarNode.getParent()!;
            this.parentNode.removeChild(this.tarNode);
            this.dataMigrationGraphicView.getXmlEntity().getSelectionModel().select(this.dataMigrationGraphicView.getXmlEntity().getTagRoot());
            this.newTarNode = this.parentNode;
        }else {
            this.tarNode!.removeAttribute("OpSign");
            this.tarNode!.removeAttribute("GroupingPolicy");
            this.tarNode!.removeAttribute("PeriodValue");
            this.tarNode!.removeAttribute("MapFormula");
            this.tarNode!.removeAttribute("IsNegtive");
            this.tarNode!.removeAttribute("DateGranularity");
            this.tarNode!.removeAttribute("TargetFieldKey");
            this.tarNode!.removeAttribute("TargetTableKey");
            this.dataMigrationGraphicView.getXmlEntity().getSelectionModel().select(this.dataMigrationGraphicView.getXmlEntity().getTagRoot());
            this.newTarNode = this.tarNode;
        }
        return true;
    }

    undo(): void {
        if (!(this.oldTarNode && this.newTarNode)) return;
        if (this.parentNode) {
            this.parentNode.addChild(this.oldTarNode);
            this.dataMigrationGraphicView.getXmlEntity().getSelectionModel().select(this.dataMigrationGraphicView.getXmlEntity().getTagRoot());
        } else {
            this.newTarNode.setAttributeValue("TargetTableKey", this.oldTarNode!.getAttributeValue("TargetTableKey", ""));
            this.newTarNode.setAttributeValue("TargetFieldKey", this.oldTarNode!.getAttributeValue("TargetFieldKey", ""));
            this.newTarNode.setAttributeValue("OpSign", this.oldTarNode!.getAttributeValue("OpSign", "AddDelta"));
            this.newTarNode.setAttributeValue("GroupingPolicy", this.oldTarNode!.getAttributeValue("GroupingPolicy", "Discrete"));
            this.newTarNode.setAttributeValue("PeriodValue", this.oldTarNode!.getAttributeValue("PeriodValue", "Default"));
            this.newTarNode.setAttributeValue("MapFormula", this.oldTarNode!.getAttributeValue("MapFormula", ""));
            this.newTarNode.setAttributeValue("IsNegtive", this.oldTarNode!.getAttributeValue("IsNegtive", "false"));
            this.newTarNode.setAttributeValue("DateGranularity", this.oldTarNode!.getAttributeValue("DateGranularity", ""));
            this.dataMigrationGraphicView.getXmlEntity().getSelectionModel().select(this.dataMigrationGraphicView.getXmlEntity().getTagRoot());
        }
    }

}