import ICmd from "../../../common/cmd/ICmd";
import DataMigrationGraphicView from "../view/DataMigrationGraphicView";
import ITagNode from "../../../common/xml/node/ITagNode";
import DataMigrationConstants from "../base/DataMigrationConstants";
import BaseConstants from "../../base/BaseConstants";
import DivElement from "../../../common/dom/element/DivElement";
import SizeInfo from "../../../common/struct/SizeInfo";
import Custom from "../../../common/component/control/Custom";


export default class AddSourceFieldCmd implements ICmd {


    private view: DataMigrationGraphicView;
    private tableKey: string;
    private newField: string;
    private tagNode: ITagNode;
    private newTagNode?: ITagNode;


    constructor(view: DataMigrationGraphicView, tableKey: string, newField: string, tagNode: ITagNode) {
        this.view = view;
        this.tableKey = tableKey;
        this.newField = newField;
        this.tagNode = tagNode;


    }

    do(): boolean {
        var tableNode = this.tagNode;

        var xmlEntity = this.view.getXmlEntity();
        if (tableNode.getTagName() == DataMigrationConstants.NODE_SourceTableCollection) {
            let sourceTable = <ITagNode>tableNode.find(DataMigrationConstants.NODE_SourceTable, DataMigrationConstants.Attr_Key, this.tableKey);
            if (sourceTable) {
                let find = sourceTable.find(DataMigrationConstants.NODE_SourceField, DataMigrationConstants.Attr_Key, this.newField);
                if (find) {
                    return true;
                }
                var fieldNode = xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_SourceField);
                fieldNode.setAttributeValue(DataMigrationConstants.Attr_Key, this.newField);
                sourceTable.addChild(fieldNode);

            /*    this.view.getSrcPoint();
                let ySpan = 70;
                let sourceColl = <ITagNode>xmlEntity.getTagRoot().getChildren()[0];
                let sourWidth = sourceColl.getAttributeValueInt(BaseConstants.ATTR_Width, 0)
                let x = sourceColl.getAttributeValueInt(BaseConstants.ATTR_X, 0);
                let y = sourceColl.getAttributeValueInt(BaseConstants.ATTR_Y, 0) + 100;
                let anchor = new DivElement();
                anchor.setAttr("tableKey", this.tableKey);
                anchor.setAttr("definition", this.newField);
                anchor.addClass("anchorpoint");
                anchor.setStyle("left", SizeInfo.valueOfPX(sourWidth + x));
                anchor.setStyle("top", SizeInfo.valueOfPX(y + ySpan + 17));
                var point = new Custom(anchor);
                this.view.getPointLIst().push(point)
                this.view.getBoardContainer().addComponent(point)

*/
                this.newTagNode = fieldNode;
            } else {
                var sourceNode = xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_SourceTable);
                sourceNode.setAttributeValue(DataMigrationConstants.Attr_Key, this.tableKey);
                tableNode.addChild(sourceNode)
                var fieldNode = xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_SourceField);
                fieldNode.setAttributeValue(DataMigrationConstants.Attr_Key, this.newField);
                sourceNode.addChild(fieldNode);
                this.newTagNode = sourceNode;

            }
        } else {
            let find = tableNode.find(DataMigrationConstants.NODE_SourceField, DataMigrationConstants.Attr_Key, this.newField);
            if (find) {
                return true;
            }
            var fieldNode = xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_SourceField);
            fieldNode.setAttributeValue(DataMigrationConstants.Attr_Key, this.newField);
            tableNode.addChild(fieldNode);
            this.newTagNode = fieldNode;
        }
        xmlEntity.update(tableNode, true);
        return true
    }


    undo(): void {
        if (this.newTagNode) {
            this.view.getXmlEntity().removeNode(this.newTagNode);
        }
    }

}