import {Link} from "../link/Link";
import IGTable from "../../../../../common/ui/graphic/IGTable";
import {CommonConstant} from "../../../base/CommonConstant";
import RectBound from "../../../../../common/struct/RectBound";

export class DataMapShadowLink extends Link{
    private static style = {stroke: CommonConstant.G_COLOR_STROKE_NORMAL, 'fill-opacity': '0.5', 'strokeWidth': 1, 'stroke-dasharray': '5,3'};
    private shadowLine: IGTable | undefined;

    drawGraphic(): IGTable {
        this.shadowLine = this.gSection.path("");
        return this.shadowLine;
    }

    getType(): string {
        return CommonConstant.NODE_Flow_Sequence;
    }

    public drawShadowToLink(toRect: RectBound): void {
        if (this.fromEvent) {
            let pos = this.getPos(this.fromEvent, toRect);
            this.shadowLine && this.shadowLine.attr({"path": pos.linestr}).attr(DataMapShadowLink.style);
        }
    }

}