import ITagNode from "../../../../common/xml/node/ITagNode";
import SpanElement from "../../../../common/dom/element/SpanElement";
import {CommonConstant} from "../../base/CommonConstant";
import DomElement from "../../../../common/dom/element/DomElement";
import TextEditor from "../../../../common/component/control/TextEditor";
import {AddFieldButton} from "./AddFieldButton";
import {DataMapGraphicView} from "../DataMapGraphicView";
import {CommonFunction} from "../../base/CommonFunction";

export class FieldRow extends SpanElement{
    private tagNode : ITagNode;
    private fieldAddButton?: AddFieldButton;
    private textEditor?: TextEditor;
    private deleteButton?: DomElement;
    private dataType: string = "";

    constructor(tagNode:ITagNode){
        super();
        this.tagNode = tagNode;
    }

    buildFormRow(Item : any, dataObjectKey : string){
        let caption = Item.Caption;
        if(this.tagNode.getTagName() == CommonConstant.NODE_SourceTableCollection){
            this.setText(CommonConstant.TEXT_SourceTable + dataObjectKey + " " + caption);
        }else if(this.tagNode.getTagName() == CommonConstant.NODE_TargetTableCollection){
            this.setText(CommonConstant.TEXT_TargetTable + dataObjectKey + " " + caption);
        }else{
            this.setText(CommonConstant.TEXT_feedBackTable + dataObjectKey + " " + caption);
        }
        let parentElement = this.getEl().parentElement;
        if (!parentElement) {
            return;
        }
        let domElement = new DomElement(parentElement);
        this.setFormRowStyle(this.tagNode,domElement);
    }

    buildTableRow(tableKey: string , caption: string, dataMapGraphicView: DataMapGraphicView) {
        this.setText(tableKey + " " + caption);
        let parentElement = this.getEl().parentElement;
        if (!parentElement) return;
        let domElement = new DomElement(parentElement);
        if(this.getTagNode().getTagName() != CommonConstant.NODE_FeedbackTable) {
            this.fieldAddButton = new AddFieldButton(this.getTagNode(), dataMapGraphicView, this.getTagNode().getTagName());
            domElement.addChild(this.fieldAddButton.getDomElement());
        }
        this.buildRow(domElement, dataMapGraphicView);

    }

    buildFieldRow(key: string , caption: string, dataType: string,  dataMapGraphicView:DataMapGraphicView, type: string){
        this.setText(key + " " + caption);
        this.dataType = dataType;
        let parentElement = this.getEl().parentElement;
        if (!parentElement) return;
        let domElement = new DomElement(parentElement);
        this.buildRow(domElement, dataMapGraphicView);
        if(type){
            this.setAttr("type", type);
        }
        this.addClass("fieldRow");
    }

    buildRow(domElement: DomElement, dataMapGraphicView: DataMapGraphicView){
        if(!this.textEditor){
            this.textEditor = new TextEditor();
            this.textEditor.setStyle("display", "none");
            let input = new DomElement(this.textEditor.getEl());
            domElement.addChild(input);
            this.textEditor.addEventListener("blur", (e: any) => {
                let target = <HTMLElement>e.target;
                target.style.backgroundColor = "#DDDDDD";
                dataMapGraphicView.initInputState(dataMapGraphicView, e);
                setTimeout(function (){
                    dataMapGraphicView.getOptStateDelegate().setNormalState();
                }, 100);
            });
            this.textEditor.addEventListener("focus", (e: any) => {
                dataMapGraphicView.getOptStateDelegate().setInputFieldState();
            });
        }
        this.setRowStyle(domElement, dataMapGraphicView);
    }

    setRowStyle(domElement: DomElement,  dataMapGraphicView: DataMapGraphicView){
        if(this.tagNode.isSelected()){
            let deleteButton = new DomElement(new Image(16,16));
            domElement.removeClass('fieldCell');
            domElement.addClass('rowSelected');
            deleteButton.setAttr("src",CommonConstant.PREFIX + CommonConstant.Delete_Button_Url);
            if(this.tagNode.getTagName() == CommonConstant.NODE_SourceTable || this.tagNode.getTagName() == CommonConstant.NODE_TargetTable) {
                deleteButton.addClass("map-delete-button-table");
            }else{
                deleteButton.addClass("map-delete-button-field");
            }
            this.deleteButton = deleteButton;
            this.deleteButton.addEventListener("click", (e: any) => {
                dataMapGraphicView.initDeleteState(dataMapGraphicView, e);
            });
            domElement.addChild(this.deleteButton);
        }else{
            domElement.removeClass('rowSelected');
            domElement.addClass('fieldCell');
            if(this.deleteButton){
                domElement.removeChild(this.deleteButton);
                this.deleteButton = undefined;
            }
        }
    }

    setFormRowStyle(tagNode:ITagNode,domElement : DomElement){
        domElement.addClass('mapTableHead');
        this.addClass('formRow');
        if(this.tagNode.isSelected()){
            domElement.addClass('rowSelected');
        }else{
            domElement.removeClass('rowSelected');
        }
    }

    getTagNode(): ITagNode {
        return this.tagNode;
    }

    getDeleteButton(): DomElement {
        return this.deleteButton!;
    }

    getTextEditor(): TextEditor {
        return this.textEditor!;
    }

    getCaption(): string {
        if(this.tagNode.getTagName() == CommonConstant.NODE_SourceField && !this.tagNode.hasAttribute(CommonConstant.NODE_Definition)) {
            return this.tagNode.getAttributeValue(CommonConstant.S_Key);
        }
        return this.tagNode.getAttributeValue(CommonConstant.NODE_Definition);
    }

    getDataType(): string{
        return this.dataType;
    }

}