import Button from "../../../../common/component/control/Button";
import ITagNode from "../../../../common/xml/node/ITagNode";
import {DataMapGraphicView} from "../DataMapGraphicView";
import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import {CommonConstant} from "../../base/CommonConstant";
import SizeInfo from "../../../../common/struct/SizeInfo";
import Label from "../../../../common/component/control/Label";
import TagNode from "../../../../common/xml/node/TagNode";
import {CommonFunction} from "../../base/CommonFunction";

export class AddFieldButton extends Button {

    private container: ButtonContainer;

    constructor(tagNode: ITagNode, dataMapGraphicView: DataMapGraphicView, tagName: string) {
        super("+");
        this.addClass("dataMap-add-button");
        this.addEventListener('click', (e: MouseEvent) => {
            if (this.getDomElement().getChildCount() > 1) {
                this.getDomElement().removeChild(this.container);
            } else {
                this.getDomElement().addChild(this.container);
                this.container.getEl().focus();
            }
        });
        this.container = new ButtonContainer(tagNode, dataMapGraphicView, tagName);
        let self = this;
        this.container.addEventListener("blur", (e: any) => {
            setTimeout(function () {
                self.getDomElement().removeChild(self.container);
            }, 1)
        }, true);
    }

    getContainer() {
        return this.container;
    }
}

class ButtonContainer extends AbstractDomElement {
    private width: number = 140;
    private type_array = [
        new Array("添加Const类型字段", "Const"),
        new Array("添加Formula类型字段", "Formula"),
        new Array("添加二开字段", ""),
    ];

    constructor(tagNode: ITagNode, dataMapGraphicView: DataMapGraphicView, tagName: string) {
        super();
        this.setStyle("width", SizeInfo.valueOfPX(this.width));
        this.addClass("addButtonContain");
        this.setAttr("tabindex", "0");
        this.initContainer(tagNode, dataMapGraphicView, tagName);
    }

    initContainer(tagNode: ITagNode, dataMapGraphicView: DataMapGraphicView, tagName: string) {
        let newTagName;
        if (tagName == CommonConstant.NODE_SourceTable) {
            newTagName = CommonConstant.NODE_SourceField;
        } else if (tagName == CommonConstant.NODE_TargetTable) {
            newTagName = CommonConstant.NODE_TargetField;
        } else {
            newTagName = CommonConstant.NODE_FeedbackField;
        }
        for (let type of this.type_array) {
            if (!type[1]) {
                if (tagNode.getAttributeValue(CommonConstant.ATTR_Type).toUpperCase() != CommonConstant.SERVICE && (
                    tagName != CommonConstant.NODE_SourceTable || dataMapGraphicView.getServiceSourceTable().indexOf(tagNode.getAttributeValue(CommonConstant.S_Key)) < 0)) {
                    continue;
                }
            }
            let label = new Label(type[0]);
            label.addClass("fieldRow");
            if (type[1] == CommonConstant.Type_Const) {
                this.addClickEvent(tagNode, dataMapGraphicView, label, newTagName, type[1], CommonConstant.Const_DefaultValue);
            } else if (type[1] == CommonConstant.Type_Formula) {
                this.addClickEvent(tagNode, dataMapGraphicView, label, newTagName, type[1], CommonConstant.Formula_DefaultValue);
            } else {
                this.addClickEvent(tagNode, dataMapGraphicView, label, newTagName, type[1], CommonConstant.DefaultValue);
            }
            this.addChild(label.getDomElement());
        }
    }

    addClickEvent(tagNode: ITagNode, dataMapGraphicView: DataMapGraphicView, label: Label, newTagName: string, type: string, defaultValue: string) {
        label.addEventListener("click", (e: MouseEvent) => {
            let newTagNode = new TagNode(newTagName);

            if (tagNode.getTagName() == CommonConstant.NODE_SourceTable) {
                if(!type){
                    if (tagNode.find(newTagName, CommonConstant.S_Key, defaultValue) != null) {
                        let i = 1;
                        while (tagNode.find(newTagName, CommonConstant.S_Key, defaultValue + i) != null) {
                            i++;
                        }
                        newTagNode.setAttributeValue(CommonConstant.S_Key, defaultValue + i);
                    }else{
                        newTagNode.setAttributeValue(CommonConstant.S_Key, defaultValue);
                    }
                }else {
                    if (tagNode.find(newTagName, CommonConstant.S_Key, type) != null) {
                        let i = 1;
                        while (tagNode.find(newTagName, CommonConstant.S_Key, type + i) != null) {
                            i++;
                        }
                        newTagNode.setAttributeValue(CommonConstant.S_Key, type + i);
                        newTagNode.setAttributeValue(CommonConstant.NODE_Definition, defaultValue + i);
                    } else {
                        newTagNode.setAttributeValue(CommonConstant.S_Key, type);
                        newTagNode.setAttributeValue(CommonConstant.NODE_Definition, defaultValue);
                    }
                }
            } else {
                if (tagNode.find(newTagName, CommonConstant.NODE_Definition, defaultValue) != null) {
                    let i = 1;
                    while (tagNode.find(newTagName, CommonConstant.NODE_Definition, defaultValue + i) != null) {
                        i++;
                    }
                    newTagNode.setAttributeValue(CommonConstant.NODE_Definition, defaultValue + i);
                } else {
                    newTagNode.setAttributeValue(CommonConstant.NODE_Definition, defaultValue);
                }
            }
            if(type) {
                newTagNode.setAttributeValue(CommonConstant.NODE_Type, type);
            }
            tagNode.addChild(newTagNode);
            dataMapGraphicView.getXmlEntity().update(tagNode, true);
            this.setStyle("display", "none");
        });
    }

}