import ITagNode from "../../../common/xml/node/ITagNode";
import {DataMapGraphicView} from "./DataMapGraphicView";
import JComponent from "../../../common/component/JComponent";
import {Container, DataMapTableLayout} from "../layout/DataMapTableLayout";
import Span from "../../../common/component/control/Span";
import TextEditor from "../../../common/component/control/TextEditor";
import {CommonConstant} from "../base/CommonConstant";
import {FieldRow} from "./element/FieldRow";
import InputElement from "../../../common/dom/element/InputElement";
import {CommonFunction} from "../base/CommonFunction";
import SizeInfo from "../../../common/struct/SizeInfo";
import Menu from "../../../common/component/menu/Menu";
import ArrayList from "../../../common/struct/ArrayList";

export class DataMapTargetTableView extends JComponent<DataMapTableLayout>{

    private tagNode: ITagNode;
    private tableLayout: DataMapTableLayout;
    private icon: Span | undefined;
    private input: Span | undefined;
    private textEditor: TextEditor | undefined;
    private tableName: string | undefined;
    private addButton: InputElement | undefined;
    private menu: Menu = new Menu();

    // textEditor是否事件初始化
    private initTextEditor : boolean = false;

    constructor(tagNode:ITagNode, tgtItems : Map<string, any> , dataMapGraphicView:DataMapGraphicView){
        super(new DataMapTableLayout(0,0));
        this.tagNode = tagNode;
        this.tableLayout = this.getDomElement();
        if(tagNode.getTagName() == CommonConstant.NODE_TargetTable){
            this.tableLayout.init(tagNode.getParent()!.getAttributeValueInt(CommonConstant.ATTR_Width, 0),CommonConstant.ROW_HEIGHT);
            this.buildTableRow(tgtItems,dataMapGraphicView);
        }else if(tagNode.getTagName() == CommonConstant.NODE_TargetTableCollection){
            this.tableLayout.init(tagNode.getAttributeValueInt(CommonConstant.ATTR_Width, 0) , CommonConstant.ROW_HEIGHT);
            this.buildFormRow(tgtItems, dataMapGraphicView);
        }
        this.tableLayout.addClass('layout');
    }

    buildFormRow(tgtItems : Map<string, any>, dataMapGraphicView: DataMapGraphicView){
        let field = this.tableLayout.addField(CommonConstant.Type_Source_TargetTable);
        let parent = this.tagNode.getParent();
        if(!parent) return;
        let fieldView = new FieldRow(this.tagNode);
        field.addClass("tablehead");
        field.addChild(fieldView);

        let tgtFormKey = dataMapGraphicView.getTgtFormKey();
        this.tableName = tgtFormKey;
        fieldView.buildFormRow(tgtItems.get(tgtFormKey),tgtFormKey);
        let container = this.tableLayout.addSpan();
        this.addTitleComponent(container,CommonConstant.NODE_TgtFormKey,tgtFormKey);
    }

    buildTableRow(tgtItems : Map<string, any> , dataMapGraphicView:DataMapGraphicView){
        let field = this.tableLayout.addField(CommonConstant.Type_Source_TargetTable);
        let fieldRow = new FieldRow(this.tagNode);
        field.addChild(fieldRow);
        field.addClass("tablehead");

        let root = this.tagNode.getParent()!.getParent()!;
        let tgtFormKey = root.getAttributeValue(CommonConstant.NODE_TgtFormKey);
        let tableKey = this.tagNode.getAttributeValue(CommonConstant.NODE_Table_Key);
        let caption = tgtItems.get(tableKey) ? tgtItems.get(tableKey).Caption : "";
        this.tableName = tgtFormKey + "|" + tableKey;
        fieldRow.buildTableRow(tableKey, caption, dataMapGraphicView);

        let container = this.tableLayout.addSpan();
        this.addTitleComponent(container,CommonConstant.NODE_Table_Key,this.tableName);
        fieldRow.setText("(表" + tgtItems.get(tableKey)?.index + ")  " + tableKey + " " + caption);
        fieldRow.addClass("tableRow");

        this.buildFieldRow(tgtFormKey, tableKey, tgtItems, dataMapGraphicView);
    }

    buildFieldRow(tgtDataObjectKey: string, tableKey: string, tgtItems : Map<string, any>, dataMapGraphicView:DataMapGraphicView){
        let children = this.tagNode.getChildren();
        let fieldList = new ArrayList();
        for (let child of children) {
            let caption = "";
            let dataType = "";
            let childTag = <ITagNode>child;
            let definition = childTag.getAttributeValue(CommonConstant.NODE_Definition);
            let type = childTag.getAttributeValue(CommonConstant.NODE_Type);
            if(fieldList.contain(definition)) continue;
            let fieldRow = new FieldRow(childTag);
            let field = this.tableLayout.addField(CommonConstant.Type_Source_TargetTable);
            field.addChild(fieldRow);
            if(!type) {
                if (tgtItems.get(definition)) {
                    caption = tgtItems.get(definition).Caption;
                    dataType = tgtItems.get(definition).DataType;
                }
            }
            fieldRow.buildFieldRow(definition, caption, dataType, dataMapGraphicView, type);
            fieldList.add(definition);
        }
    }

    addTitleComponent(container: Container,attrKey: string,attrValue: string){
        this.icon = container.getIcon();
        this.addButton = container.getAddButton();
        this.input = container.getInput();
        this.textEditor = container.getTextEditor();
        this.icon.getDomElement().setAttr(attrKey,attrValue);
        this.addButton.setAttr(attrKey,attrValue);
        this.input.getDomElement().setAttr(attrKey,attrValue);
    }

    isTableTitle(){
        return this.tagNode.getTagName() == CommonConstant.NODE_TargetTableCollection;
    }


    setInitTextEditor(value : boolean) {
        this.initTextEditor = value;
    }

    getInitTextEditor(){
        return this.initTextEditor;
    }

    getAddIcon(){
        return this.icon!;
    }

    getInputButton(): InputElement{
        return this.addButton!;
    }

    getInputPromptSpan(){
        return this.input;
    }

    getInputTextEditor(){
        return this.textEditor;
    }

    getMenu(): Menu {
        this.menu.clearChildren();
        return this.menu;
    }
    getTableName(): string {
        return this.tableName!;
    }

    containPoint(x: number,y: number): boolean{
        return CommonFunction.containPoint(x,y, this.getEl());
    }

    getWidth(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableLayout.getWidth()!);
    }

    getHeight(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableLayout.getHeight()!);
    }

    locRow(x: number, y: number): FieldRow | null{
        return CommonFunction.locRow(x, y, this.tableLayout);
    }

    getTagNode(): ITagNode {
        return this.tagNode;
    }

}