import AbstractGraphicView from "../../base/AbstractGraphicView";
import {DataMapOptStateDelegate} from "../state/DataMapOptStateDelegate";
import AbstractPropertyDefine from "../../plugin/property/base/AbstractPropertyDefine";
import {DataMapPropertyDefine} from "../base/DataMapPropertyDefine";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import Paras from "../../../common/struct/Paras";
import ActionNames from "../../../common/event/ActionNames";
import ContainerPanel from "../../../common/component/container/panel/ContainerPanel";
import GDataMapElement from "../../plugin/graphic/snap/GDataMapElement";
import Custom from "../../../common/component/control/Custom";
import DomElement from "../../../common/dom/element/DomElement";
import BorderPanel from "../../../common/component/container/panel/BorderPanel";
import H5VFlexPanel from "../../../common/component/container/panel/H5VFlexPanel";
import DivElement from "../../../common/dom/element/DivElement";
import {CommonFunction} from "../base/CommonFunction";
import SizeInfo from "../../../common/struct/SizeInfo";
import ITagNode from "../../../common/xml/node/ITagNode";
import {DataMapTargetTableView} from "./DataMapTargetTableView";
import {DataMapSourceTableView} from "./DataMapSourceTableView";
import {CommonConstant} from "../base/CommonConstant";
import IGTable from "../../../common/ui/graphic/IGTable";
import JComponent from "../../../common/component/JComponent";
import {FieldRow} from "./element/FieldRow";
import DomUtil from "../../../common/dom/DomUtil";
import GDataMigration from "../../plugin/graphic/snap/GDataMigration";
import CmdQueue from "../../../common/cmd/CmdQueue";
import {MoveDataMapTableCmd} from "../cmd/MoveDataMapTableCmd";
import ArrayList from "../../../common/struct/ArrayList";
import {AddLinkCmd} from "../cmd/AddLinkCmd";
import {DataMapMoveFieldCmd} from "../cmd/DataMapMoveFieldCmd";
import {ModifyFieldAttrCmd} from "../cmd/ModifyFieldAttrCmd";
import {DeleteFieldRowCmd} from "../cmd/DeleteFieldRowCmd";
import {Link} from "./element/link/Link";
import {ArrowLine} from "./element/link/ArrowLine";
import {AddSourceFieldCmd} from "../cmd/AddSourceFieldCmd";
import {DataMapFeedbackView} from "./DataMapFeedbackView";
import {DeleteLinkCmd} from "../cmd/DeleteLinkCmd";
import {AddTargetFieldCmd} from "../cmd/AddTargetFieldCmd";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import {FeedbackEventListener} from "../event/FeedbackEventListener";
import IWorkSpace from "../../../common/workspace/IWorkSpace";
import AddSourceFieldsCmd from "../cmd/AddSourceFieldsCmd";
import AddTargetFieldsCmd from "../cmd/AddTargetFieldsCmd";
import {AddFeedBackFieldCmd} from "../cmd/AddFeedBackFieldCmd";
import AddFeedBackFieldsCmd from "../cmd/AddFeedBackFieldsCmd";
import Button from "../../../common/component/control/Button";
import Events from "../../../common/event/Events";


export class DataMapGraphicView extends AbstractGraphicView<DataMapOptStateDelegate>{

    private board : ContainerPanel;
    private boardContainerPanel : ContainerPanel;
    private paper : GDataMapElement;
    private gridBorder : BorderPanel;
    private stcView: H5VFlexPanel;
    private ttcView: H5VFlexPanel;
    private ftcViewList: ArrayList<H5VFlexPanel>;
    private srcItems : Map<string, any>;
    private tgtItems : Map<string, any>;
    private srcFormKey!: string;
    private tgtFormKey!: string;
    private srcDataObjectKey!: string;
    private tgtDataObjectKey!: string;
    private feedbackItems: ArrayList<Map<string, any>> ;
    private linkDataMapButton?: Button;

    private srcForeignObject: SVGForeignObjectElement | undefined;
    private tagForeignObject: SVGForeignObjectElement | undefined;
    private feedbackForeignObjectList: ArrayList<SVGForeignObjectElement | undefined> = new ArrayList<SVGForeignObjectElement | undefined>();
    // 视图元素集合
    private sourceViewElements: DataMapSourceTableView[] = [];
    private targetViewElements: DataMapTargetTableView[] = [];
    private feedbackViewElements: ArrayList<DataMapFeedbackView[]> = new ArrayList<DataMapFeedbackView[]>();

    private sourceViews: Map<string, DataMapSourceTableView> = new Map<string, DataMapSourceTableView>();
    private targetViews: Map<string, DataMapTargetTableView> = new Map<string, DataMapTargetTableView>();
    private feedbackViews: Map<string, DataMapFeedbackView> = new Map<string, DataMapFeedbackView>();

    private scrPoints: Map<string, DivElement>;
    private tarPoints: Map<string, DivElement>;
    private tarRightPoints: Map<string, DivElement>
    private feedbackPointList: ArrayList<Map<string, DivElement>>;
    private mapLinks: Map<String, Link>;
    //锚点集合
    private pointList: Custom[] = [];

    private xmlEntity!: IXmlEntity;
    private path?: string;
    private selectViewName: string = "";
    private selectFieldRow?: FieldRow;
    private selectFieldTagNode?: ITagNode;

    private selectSourceView: DataMapSourceTableView | undefined;
    private selectTargetView: DataMapTargetTableView | undefined;
    private selectFeedBackView: DataMapFeedbackView | undefined;
    private operationDispatcher?: OperationDispatcher;

    private extendSourceToTargetLinks: String[] = [];
    private extendTargetToFeedbackLinks: String[] = [];
    private serviceSourceTable: String[] = [];

    constructor(){
        super(0, 0, 64, 0);
        this.srcItems = new Map<string, any>();
        this.tgtItems = new Map<string, any>();
        this.feedbackItems = new ArrayList<Map<string, any>>();

        this.scrPoints = new Map<string, DivElement>();
        this.tarPoints = new Map<string, DivElement>();
        this.tarRightPoints = new Map<string, DivElement>();
        this.mapLinks = new Map<string, Link>();
        this.feedbackPointList = new ArrayList<Map<string, DivElement>>();

        //@ts-ignore
        this.paper = new GDataMapElement(Snap("100%","100%"));
        this.paper.attr({'preserveAspectRatio':"none meet",'tabindex' : 0});
        this.paper.addClass("dataMapLink");
        let paperCustom = new Custom(new DomElement(this.paper.getHtmlElement()));

        this.boardContainerPanel = new ContainerPanel();
        this.boardContainerPanel.addComponent(paperCustom);
        this.boardContainerPanel.addClass("boardContainer");
        this.addComponent(this.boardContainerPanel,1,1,4,4);

        this.stcView = new H5VFlexPanel();
        this.stcView.addClass("sourceTableCollectionView");

        this.ttcView = new H5VFlexPanel();
        this.ttcView.addClass("targetTableCollectionView");

        this.ftcViewList = new ArrayList<H5VFlexPanel>();

        this.gridBorder = new BorderPanel(15,0,15,0);
        this.gridBorder.addClass("gridBorder");
        this.gridBorder.setLeft(this.stcView);
        this.gridBorder.setCenter(this.ttcView);

        this.board = new ContainerPanel();
        this.board.setStyle("overflow", "visible");
        this.board.addComponent(this.gridBorder);

        this.initViewMouseEvent(this.paper);
    }

    createOptStateDelegate(): DataMapOptStateDelegate {
        return new DataMapOptStateDelegate(this);
    }

    getPropertyDefine(): AbstractPropertyDefine {
        return DataMapPropertyDefine.getInstance();
    }

    load(xmlEntity: IXmlEntity): void {
        this.xmlEntity = xmlEntity;
    }

    loadView(xmlEntity: IXmlEntity, operationDispatcher: OperationDispatcher, path: string): void {
        this.removeCache();
        this.operationDispatcher = operationDispatcher;
        this.xmlEntity = xmlEntity;
        this.path = path;
        let mapTagRoot = xmlEntity.getTagRoot();
        CommonFunction.reloadTableCollectionHeight(xmlEntity);
        this.createDataMapView(mapTagRoot, path);
        let paperHeight = CommonFunction.checkDesignViewHeight(xmlEntity);
        let htmlElement = this.paper.getHtmlElement();
        if(paperHeight < 800){
            htmlElement.style["height"] = SizeInfo.valueOfPX(800).toString();
        }else{
            htmlElement.style["height"] = SizeInfo.valueOfPX(paperHeight).toString();
        }
    }

    createDataMapView(mapTagRoot:ITagNode, path: string){
        if (!mapTagRoot) return;
        let nodes = mapTagRoot.getChildren();
        let nodeSrc,nodeTtc;
        for (let i = 0; i < nodes.length ; i++) {
            let tagName = (<ITagNode>nodes[i]).getTagName();
            if(tagName == CommonConstant.NODE_SourceTableCollection) {
                nodeSrc = <ITagNode>nodes[i];
                this.CreateSourceTableView(nodeSrc, path);
                continue
            }
            if(tagName == CommonConstant.NODE_TargetTableCollection) {
                nodeTtc = <ITagNode>nodes[i];
                this.CreateTargetTableView(nodeTtc);
                continue
            }
            if(nodeSrc && nodeTtc && tagName == CommonConstant.NODE_FeedbackCollection) {
                let nodeFeedbackList = (<ITagNode>nodes[i]).getChildren();
                for (let i = 0; i < nodeFeedbackList.length; i++) {
                    this.CreateFeedBackTableView(<ITagNode>nodeFeedbackList[i], i);
                    let feedbackPoints =  this.addTargetAndFeedBackAnchorPoint(nodeTtc, <ITagNode>nodeFeedbackList[i]);
                    this.loadTargetToFeedBackLinks(nodeTtc, <ITagNode>nodeFeedbackList[i], feedbackPoints, i);
                }
            }
        }
        if(!nodeTtc) return;
        this.addAnchorPoint(nodeSrc, nodeTtc);
        this.loadLinks(nodeSrc,nodeTtc);
    }

    loadTargetToFeedBackLinks(nodeTtc : ITagNode, nodeFeedback: ITagNode, feedbackPoints: Map<string, DivElement>, index: number) {
        let targetTables = nodeTtc.getChildren();
        if (!targetTables) return;
        // 普通连接线
        for (let targetTable of targetTables) {
            let table = <ITagNode>targetTable;
            let targetTableKey = table.getAttributeValue(CommonConstant.NODE_Table_Key);
            let targetFields = table.getChildren();
            if (!targetFields) continue;
            for (let targetField of targetFields) {
                let field = <ITagNode>targetField;
                let definition = field.getAttributeValue(CommonConstant.NODE_Definition);
                if (field.getChildren().length > 0) {
                    let formKey = nodeFeedback.getAttributeValue(CommonConstant.NODE_FormKey);
                    let tableKey, fieldKey = "", opSign, condition, postTrigger, postFormulaTrigger;
                    for (let i = 0; i < field.getChildren().length; i++) {
                        let node = <ITagNode>field.getChildren()[i];
                        let nodeFeedFormKey = node.getAttributeValue(CommonConstant.NODE_FeedFormKey);
                        if (formKey != nodeFeedFormKey) continue;
                        tableKey = node.getAttributeValue(CommonConstant.NODE_FeedbackTableKey);
                        fieldKey = node.getAttributeValue(CommonConstant.NODE_FieldKey);
                        condition = node.getAttributeValue(CommonConstant.NODE_Condition, "");
                        opSign = node.getAttributeValue(CommonConstant.NODE_OpSign, CommonConstant.NODE_OpSign_Value);
                        let childNodes = node.getChildren();
                        for (let j = 0; j < childNodes.length; j++) {
                            let childNode = <ITagNode>childNodes[j];
                            if (childNode.getTagName() == CommonConstant.NODE_PostTrigger) {
                                postTrigger = childNode.getCDATAValue();
                                continue;
                            }
                            if (childNode.getTagName() == CommonConstant.NODE_PostFormulaTrigger) {
                                postFormulaTrigger = childNode.getCDATAValue();
                            }
                        }
                        let tarPoint = this.tarRightPoints.get(targetTableKey + "_" + definition);
                        let feedbackPoint = feedbackPoints.get(tableKey + "_" + fieldKey);

                        if (tarPoint && feedbackPoint) {
                            let arrowLine = new ArrowLine();
                            arrowLine.initGSection(this.paper.section())
                            arrowLine.setFromNode({
                                x: tarPoint!.getOffsetLeft(),
                                y: tarPoint!.getOffsetTop() - 30,
                                width: 4,
                                height: 4
                            }, 0);
                            arrowLine.setToNode({
                                x: feedbackPoint!.getOffsetLeft(),
                                y: feedbackPoint!.getOffsetTop() - 30,
                                width: 4,
                                height: 4
                            });
                            let controlNode = arrowLine.getControlNode();

                            controlNode.attr({"type": "feedBack"});
                            controlNode.attr({"pathId": targetTableKey + "*_*" + definition + "*_*" + tableKey + "*_*" + fieldKey});
                            controlNode.attr({"targetTableKey": targetTableKey});
                            controlNode.attr({"TableKey": tableKey});
                            controlNode.attr({"FeedFormKey": formKey});
                            controlNode.attr({"FieldKey": fieldKey});
                            controlNode.attr({"FeedFieldCaption": this.feedbackItems.getSize() > 0 ? (this.feedbackItems.get(index).get(fieldKey) ? this.feedbackItems.get(index).get(fieldKey).Caption : "") : ""});
                            controlNode.attr({"TargetFieldKey": definition});
                            controlNode.attr({"TargetFieldCaption": this.tgtItems.get(definition) ? this.tgtItems.get(definition).Caption : ""});
                            controlNode.attr({"OpSign": opSign});
                            controlNode.attr({"class": "fieldCell_pointer"});
                            controlNode.attr({"PostTrigger": postTrigger ? postTrigger : ""});
                            controlNode.attr({"PostFormulaTrigger": postFormulaTrigger ? postFormulaTrigger : ""});
                            controlNode.attr({"Condition": condition});
                            this.mapLinks.set(targetTableKey + "*_*" + definition + "*_*" + tableKey + "*_*" + fieldKey, arrowLine);
                        }
                    }
                }
            }
        }
    }


    addAnchorPoint(nodeSrc : ITagNode | undefined, nodeTtc : ITagNode | undefined){
        let ySpan = this.addSourceAnchorPoint(nodeSrc);
        this.addTargetAnchorPoint(nodeTtc,ySpan);
        this.boardContainerPanel.display();
    }

    addTargetAndFeedBackAnchorPoint(nodeTtc : ITagNode, nodeFeedback : ITagNode): Map<string, DivElement>{
        this.addTargetRightAnchorPoint(nodeTtc);
        let feedbackPoints = this.addFeedbackAnchorPoint(nodeFeedback);
        this.boardContainerPanel.display();
        return feedbackPoints;
    }

    addFeedbackAnchorPoint(nodeFeedback : ITagNode): Map<string, DivElement>{
        let x = nodeFeedback.getAttributeValueInt(CommonConstant.ATTR_X,0);
        let y = nodeFeedback.getAttributeValueInt(CommonConstant.ATTR_Y,0)+ 100;
        let feedbackTables = nodeFeedback.getChildren();
        let ySpan = 2 * CommonConstant.ROW_HEIGHT;
        let feedbackPoints = new Map<string, DivElement>();
        for (let table of feedbackTables){
            let tableTagNode = <ITagNode>table;
            let feedTableKey = tableTagNode.getAttributeValue(CommonConstant.NODE_FeedbackTableKey);
            let fieldList = new ArrayList();
            let fields = tableTagNode.getChildren();
            if(!fields) continue;
            for (let field of fields){
                let fieldTagNode = <ITagNode>field;
                let fieldKey = fieldTagNode.getAttributeValue(CommonConstant.NODE_FieldKey);
                if(fieldList.contain(feedTableKey + "_" + fieldKey)) continue;
                fieldList.add(feedTableKey + "_" + fieldKey);
                let anchor = new DivElement();
                anchor.setAttr("tableKey",feedTableKey);
                anchor.setAttr("fieldKey", fieldKey);
                anchor.addClass("anchorPoint");
                anchor.setStyle("left", SizeInfo.valueOfPX(x));
                anchor.setStyle("top", SizeInfo.valueOfPX(y + ySpan + 2));
                let custom = new Custom(anchor);
                feedbackPoints.set(feedTableKey + "_" + fieldKey, anchor);
                this.pointList.push(custom);
                this.boardContainerPanel.addComponent(custom);
                ySpan = ySpan + CommonConstant.ROW_HEIGHT;
            }
            ySpan = ySpan + 2 * CommonConstant.ROW_HEIGHT;
        }
        this.feedbackPointList.add(feedbackPoints);
        return feedbackPoints;
    }

    addTargetRightAnchorPoint(nodeTtc : ITagNode){
        let x = nodeTtc.getAttributeValueInt(CommonConstant.ATTR_X,0);
        let y = nodeTtc.getAttributeValueInt(CommonConstant.ATTR_Y,0)+100;
        let targetTables = nodeTtc.getChildren();
        let width = nodeTtc.getAttributeValueInt(CommonConstant.ATTR_Width,0);
        let ySpan = 2 * CommonConstant.ROW_HEIGHT;
        for (let table of targetTables){
            let tableTagNode = <ITagNode>table;
            let targetTableKey = tableTagNode.getAttributeValue(CommonConstant.NODE_Table_Key);
            let fieldList = new ArrayList();
            let fields = tableTagNode.getChildren();
            if(!fields) continue;
            for (let field of fields){
                let fieldTagNode = <ITagNode>field;
                if(!fieldTagNode.getChildren()) return;
                let definition = fieldTagNode.getAttributeValue(CommonConstant.NODE_Definition);
                let feedbacks = fieldTagNode.getChildren();
                for (let i = 0 ; i < feedbacks.length ; i++){
                    let feedbackNode = <ITagNode>feedbacks[i];
                    let fieldKey = feedbackNode.getAttributeValue(CommonConstant.NODE_FieldKey);
                    let feedFormKey = feedbackNode.getAttributeValue(CommonConstant.NODE_FeedFormKey);
                    let tableKey = feedbackNode.getAttributeValue(CommonConstant.NODE_FeedbackTableKey);
                }
                if(fieldList.contain(targetTableKey + "_" + definition)) continue;
                fieldList.add(targetTableKey + "_" + definition);
                let anchor = new DivElement();
                anchor.setAttr("tableKey",targetTableKey);
                anchor.setAttr("definition", definition);
                anchor.addClass("anchorPoint");
                anchor.setStyle("left", SizeInfo.valueOfPX(width + x - 2));
                anchor.setStyle("top", SizeInfo.valueOfPX(y + ySpan + 2));
                //anchor.setAttr("targetTableKey",targetTableKey);
                //anchor.setAttr("targetFieldKey",targetFieldKey);
                this.tarRightPoints.set(targetTableKey + "_" + definition,anchor);
                let custom = new Custom(anchor);
                this.pointList.push(custom);
                this.boardContainerPanel.addComponent(custom);
                ySpan = ySpan + CommonConstant.ROW_HEIGHT;
            }
            ySpan = ySpan + 2 * CommonConstant.ROW_HEIGHT;
        }
        return ySpan;
    }



    CreateSourceTableView(nodeSrc:ITagNode, path: string){
        if(this.srcItems.size < 1) return;
        let dataMapSourceTableView = new DataMapSourceTableView(nodeSrc,this.srcItems, this);
        this.addSourceTableChild(dataMapSourceTableView);
        let children = nodeSrc.getChildren();
        for (let child of children) {
            let dataMapSourceTableViewChild = new DataMapSourceTableView(<ITagNode>child,this.srcItems, this);
            this.addSourceTableChild(dataMapSourceTableViewChild);
        }
        let extend = nodeSrc.getParent()!.getAttributeValue("Extend");
        if( nodeSrc.getParent()!.hasAttribute("Extend")){
            this.linkDataMapButton = new Button("关联数据映射");
            this.linkDataMapButton.addClass("linkDataMapButton");
            this.linkDataMapButton.addEventListener(Events.MouseDown, (event: any) => {
                //@ts-ignore
                const exp = `OpenDataMap('${extend}','${path}','')`
                this.operationDispatcher?.eval(exp);
                console.log(extend);
            });
            this.boardContainerPanel.addComponent(this.linkDataMapButton);
        }
        this.srcForeignObject = this.setTableViewStyle(nodeSrc, this.stcView);
    }

    addSourceTableChild(row:DataMapSourceTableView){
        row.addClass("tableArea");
        this.stcView.addComponent(row);
        this.sourceViews.set(row.getTableName(),row);
        this.sourceViewElements.push(row);
    }

    CreateTargetTableView(nodeTtc:ITagNode){
        if(this.tgtItems.size < 1) return;
        let dataMapTargetTableView = new DataMapTargetTableView(nodeTtc,this.tgtItems, this);
        this.addTargetTableChild(dataMapTargetTableView);
        let children = nodeTtc.getChildren();
        for (let child of children) {
            let dataMapTargetTableViewChild = new DataMapTargetTableView(<ITagNode>child,this.tgtItems, this);
            this.addTargetTableChild(dataMapTargetTableViewChild);
        }
        this.tagForeignObject =  this.setTableViewStyle(nodeTtc,this.ttcView);
    }

    addTargetTableChild(row: DataMapTargetTableView){
        row.addClass("tableArea");
        this.ttcView.addComponent(row);
        this.targetViews.set(row.getTableName(),row);
        this.targetViewElements.push(row);
    }

    CreateFeedBackTableView(feedbackNode: ITagNode, index: number){
        if(this.feedbackItems.getSize() < 1) return;
        let dataMapFeedbackView = new DataMapFeedbackView(feedbackNode, this.feedbackItems.get(index), index, this);
        let ftcView = new H5VFlexPanel();
        ftcView.addClass("feedbackCollectionView"+ index);
        let listener = new FeedbackEventListener(this, this.operationDispatcher!);
        listener.initFeedBackEvent(ftcView.getDomElement(), index);
        this.ftcViewList.add(ftcView);
        this.gridBorder.setRight(ftcView);
        let feedbackView: DataMapFeedbackView[] = [];
        this.feedbackViewElements.add(feedbackView);
        this.addFeedbackTableChild(dataMapFeedbackView, ftcView , feedbackView);
        let children = feedbackNode.getChildren();
        for(let child of children){
            let dataMapFeedbackViewChild = new DataMapFeedbackView(<ITagNode>child, this.feedbackItems.get(index), index, this);
            this.addFeedbackTableChild(dataMapFeedbackViewChild, ftcView ,feedbackView);
        }

        let feedbackForeignObject = this.setTableViewStyle(feedbackNode, ftcView);
        this.feedbackForeignObjectList.add(feedbackForeignObject);
    }

    addFeedbackTableChild(row: DataMapFeedbackView, ftcView: H5VFlexPanel ,feedbackView: DataMapFeedbackView[]){
        row.addClass("tableArea");
        ftcView.addComponent(row);
        this.feedbackViews.set(row.getTableName(),row);
        feedbackView.push(row);
    }

    setTableViewStyle(node: ITagNode, tableView: H5VFlexPanel):SVGForeignObjectElement | undefined{
        let height = node.getAttributeValueInt(CommonConstant.ATTR_Height,0);
        let length = node.getChildren().length;
        if(length > 0) {
            let lastNode = <ITagNode>node.getChildren()[length - 1];
            if (lastNode.getChildren().length < 5) {
                height = height + (150-lastNode.getChildren().length * CommonConstant.ROW_HEIGHT);
            }
        }else{
            height = 210;
        }
        let width = node.getAttributeValueInt(CommonConstant.ATTR_Width,0);
        let x = node.getAttributeValueInt(CommonConstant.ATTR_X,0);
        let y = node.getAttributeValueInt(CommonConstant.ATTR_Y,0);
        tableView.setHeight(SizeInfo.valueOfPX(height));
        tableView.setWidth(SizeInfo.valueOfPX(width));
        tableView.display();
        return this.paper.table(x,y,width,height,tableView.getEl());
    }



    addSourceAnchorPoint(nodeSrc: ITagNode | undefined) : number{
        if(!nodeSrc) return 0;
        let x = nodeSrc.getAttributeValueInt(CommonConstant.ATTR_X,0);
        let y = nodeSrc.getAttributeValueInt(CommonConstant.ATTR_Y,0)+100;
        let sourceTables = nodeSrc.getChildren();
        let width = nodeSrc.getAttributeValueInt(CommonConstant.ATTR_Width,0);
        let ySpan = 2 * CommonConstant.ROW_HEIGHT;
        for (let table of sourceTables){
            let tableTagNode = <ITagNode>table;
            let sourceTableKey = tableTagNode.getAttributeValue(CommonConstant.NODE_Table_Key);
            let fieldList = new ArrayList();
            let fields = tableTagNode.getChildren();
            if(!fields) continue;
            for (let field of fields){
                let fieldTagNode = <ITagNode>field;
                let fieldKey = CommonFunction.getSourceFieldValue(fieldTagNode);
                let targetFieldKey = fieldTagNode.getAttributeValue(CommonConstant.NODE_TargetFieldKey);
                let targetTableKey = fieldTagNode.getAttributeValue(CommonConstant.NODE_TargetTableKey);
                if(fieldList.contain(sourceTableKey + "_" + fieldKey)) continue;
                fieldList.add(sourceTableKey + "_" + fieldKey);
                let anchor = new DivElement();
                anchor.setAttr("tableKey",sourceTableKey);
                anchor.setAttr("fieldKey", fieldKey);
                anchor.addClass("anchorPoint");
                anchor.setStyle("left", SizeInfo.valueOfPX(width + x - 2));
                anchor.setStyle("top", SizeInfo.valueOfPX(y + ySpan + 2));
                anchor.setAttr("targetTableKey",targetTableKey);
                anchor.setAttr("targetFieldKey",targetFieldKey);
                this.scrPoints.set(sourceTableKey + "_" + fieldKey,anchor);
                let custom = new Custom(anchor);
                this.pointList.push(custom);
                this.boardContainerPanel.addComponent(custom);
                ySpan = ySpan + CommonConstant.ROW_HEIGHT;
            }
            ySpan = ySpan + 2 * CommonConstant.ROW_HEIGHT;
        }
        return ySpan;
    }

    addTargetAnchorPoint(nodeTtc : ITagNode | undefined,ySpan: number){
        if(!nodeTtc) return;
        let x = nodeTtc.getAttributeValueInt(CommonConstant.ATTR_X,0);
        let y = nodeTtc.getAttributeValueInt(CommonConstant.ATTR_Y,0)+ 100;
        let targetTables = nodeTtc.getChildren();
        ySpan = 2 * CommonConstant.ROW_HEIGHT;
        for (let table of targetTables){
            let tableTagNode = <ITagNode>table;
            let targetTableKey = tableTagNode.getAttributeValue(CommonConstant.NODE_Table_Key);
            let fieldList = new ArrayList();
            let fields = tableTagNode.getChildren();
            if(!fields) continue;
            for (let field of fields){
                let fieldTagNode = <ITagNode>field;
                let definition = fieldTagNode.getAttributeValue(CommonConstant.NODE_Definition);
                if(fieldList.contain(targetTableKey + "_" + definition)) continue;
                fieldList.add(targetTableKey + "_" + definition);
                let anchor = new DivElement();
                anchor.setAttr("tableKey",targetTableKey);
                anchor.setAttr("definition", definition);
                anchor.addClass("anchorPoint");
                anchor.setStyle("left", SizeInfo.valueOfPX(x));
                anchor.setStyle("top", SizeInfo.valueOfPX(y + ySpan + 2));
                let custom = new Custom(anchor);
                this.tarPoints.set(targetTableKey + "_" + definition, anchor);
                this.pointList.push(custom);
                this.boardContainerPanel.addComponent(custom);
                ySpan = ySpan + CommonConstant.ROW_HEIGHT;
            }
            ySpan = ySpan + 2 * CommonConstant.ROW_HEIGHT;
        }
    }

    loadLinks(nodeSrc : ITagNode | undefined,nodeTtc: ITagNode | undefined) {
        let sourceTables = nodeSrc!.getChildren();
        if (!sourceTables) return;
        // 普通连接线
        for (let sourceTable of sourceTables) {
            let sorTable = <ITagNode>sourceTable;
            let tableKey = sorTable.getAttributeValue(CommonConstant.NODE_Table_Key);
            let sourceFields = sorTable.getChildren();
            if (!sourceFields) continue;
            for (let sourceField of sourceFields) {
                let field = <ITagNode>sourceField;
                let fieldKey = CommonFunction.getSourceFieldValue(field);
                let targetFieldKey = field.getAttributeValue(CommonConstant.NODE_TargetFieldKey);
                let targetTableKey = field.getAttributeValue(CommonConstant.NODE_TargetTableKey);
                let linkType = 0; //正常连线
                if(field.hasAttribute("EdgeType") && field.getAttributeValue("EdgeType") == "Focus"){
                    linkType = CommonConstant.LinkType_Focus; //数据映射关注映射
                }
                if (targetFieldKey) {
                    let srcPoint = this.scrPoints.get(tableKey + "_" + fieldKey);
                    let key = targetTableKey + "_" + targetFieldKey;
                    let tarPoint= undefined;
                    //发现部分SourceField标签中有TargetFieldKey属性没有TargetTableKey属性
                    if(key.startsWith("_")){
                        let targetTables = nodeTtc!.getChildren();
                        if (!targetTables) return;
                        for (let targetTable of targetTables) {
                            let tarTable = <ITagNode>targetTable;
                            let tarTableKey = tarTable.getAttributeValue(CommonConstant.NODE_Table_Key);
                            tarPoint = this.tarPoints.get(tarTableKey + "_" + targetFieldKey);
                            if(tarPoint){
                                targetTableKey = tarTableKey;
                                break;
                            }
                        }
                    }else{
                        tarPoint = this.tarPoints.get(targetTableKey + "_" + targetFieldKey);
                    }

                    if(!targetTableKey || this.mapLinks.get(tableKey + "*_*" + fieldKey + "*_*" + targetTableKey + "*_*" + targetFieldKey)) continue; //key值重复

                    if (srcPoint && tarPoint) {
                        let arrowLine = new ArrowLine();
                        arrowLine.initGSection(this.paper.section())
                        arrowLine.setFromNode({
                            x: srcPoint!.getOffsetLeft(),
                            y: srcPoint!.getOffsetTop() - 30,
                            width: 4,
                            height: 4
                        },linkType);
                        arrowLine.setToNode({
                            x: tarPoint!.getOffsetLeft(),
                            y: tarPoint!.getOffsetTop() - 30,
                            width: 4,
                            height: 4
                        });
                        let controlNode = arrowLine.getControlNode();

                        controlNode.attr({"type": "normal"});
                        controlNode.attr({"Key": field.getAttributeValue(CommonConstant.S_Key)});
                        controlNode.attr({"pathId": tableKey + "*_*" + fieldKey + "*_*" + targetTableKey + "*_*" + targetFieldKey});
                        controlNode.attr({"srcTableKey": tableKey});
                        controlNode.attr({"targetTableKey": targetTableKey});
                        controlNode.attr({"class": "fieldCell_pointer"});
                        controlNode.attr({"sourceFieldCaption": this.srcItems.get(fieldKey) ? this.srcItems.get(fieldKey).Caption : ""});
                        controlNode.attr({"targetFieldCaption": this.tgtItems.get(targetFieldKey) ? this.tgtItems.get(targetFieldKey).Caption : ""});
                        this.mapLinks.set(tableKey + "*_*" + fieldKey + "*_*"  + targetTableKey + "*_*" + targetFieldKey, arrowLine);
                    }
                }
            }
        }
    }


    removeCache(){
        this.stcView.removeAll();
        this.ttcView.removeAll();
        this.ftcViewList = new ArrayList<H5VFlexPanel>();
        if (this.srcForeignObject) {
            this.srcForeignObject.remove();
        }
        if (this.tagForeignObject) {
            this.tagForeignObject.remove();
        }
        for (let i = 0 ;i < this.feedbackForeignObjectList.getSize(); i++){
            this.feedbackForeignObjectList.get(i)!.remove();
        }
        if(this.sourceViewElements.length > 0){
            this.sourceViewElements = [];
        }
        if(this.targetViewElements.length > 0){
            this.targetViewElements = [];
        }
        this.feedbackViewElements = new ArrayList<DataMapFeedbackView[]>();
        for (let custom of this.pointList) {
            this.boardContainerPanel.removeComponent(custom);
            this.pointList = [];
        }
        if(this.linkDataMapButton) {
            this.boardContainerPanel.removeComponent(this.linkDataMapButton);
        }
        for (let scrPoint of this.mapLinks.values()) {
            scrPoint.remove();
        }
        this.feedbackPointList = new ArrayList<Map<string, DivElement>>();
        this.mapLinks.clear();
        this.scrPoints.clear();
        this.tarPoints.clear();
        this.tarRightPoints.clear();
    }

    setExtendSourceToTargetLinks(list: String[]){
        this.extendSourceToTargetLinks = list;
    }

    setExtendTargetToFeedbackLinks(list: String[]){
        this.extendTargetToFeedbackLinks = list;
    }

    getExtendSourceToTargetLinks(){
        return this.extendSourceToTargetLinks;
    }

    getExtendTargetToFeedbackLinks(){
        return this.extendTargetToFeedbackLinks
    }

    setServiceSourceTable(list: String[]){
        this.serviceSourceTable = list;
    }

    getServiceSourceTable(){
        return this.serviceSourceTable;
    }

    setSrcMap(map: Map<string, any>) {
        this.srcItems = map;
    }

    setTarMap(map: Map<string, any>) {
        this.tgtItems = map;
    }

    setSrcFormKey(srcFormKey: string){
        this.srcFormKey = srcFormKey;
    }

    setTgtFormKey(tgtFormKey: string){
        this.tgtFormKey = tgtFormKey;
    }

    setSrcDataObjectKey(srcDataObjectKey: string){
        this.srcDataObjectKey = srcDataObjectKey;
    }

    setTgtDataObjectKey(tgtDataObjectKey: string){
        this.tgtDataObjectKey = tgtDataObjectKey;
    }

    getSrcFormKey() : string{
        return this.srcFormKey;
    }

    getTgtFormKey() : string{
        return this.tgtFormKey;
    }

    getSrcDataObjectKey(): string{
        return this.srcDataObjectKey;
    }

    getTgtDataObjectKey(): string{
        return this.tgtDataObjectKey;
    }

    setFeedBackMapList(list: ArrayList<Map<string,any>>){
        this.feedbackItems = list;
    }

    notifyEvent(cmd: string, paras: Paras): void {
        switch (cmd) {
            case ActionNames.model_node_add:
                this.loadView(this.xmlEntity, this.operationDispatcher!, this.path!);
                break;
            case ActionNames.model_node_remove:
                this.loadView(this.xmlEntity, this.operationDispatcher!, this.path!);
                break;
            case ActionNames.model_node_update:
                this.loadView(this.xmlEntity, this.operationDispatcher!, this.path!);
                break;
            case ActionNames.model_node_update_select:
                this.loadView(this.xmlEntity, this.operationDispatcher!, this.path!);
                break;
        }
    }

    //初始化视图面板鼠标事件
    initViewMouseEvent(paper: IGTable): void{
        paper.getHtmlElement().addEventListener('contextmenu', function (e: any) {
            e.preventDefault();
        })
        paper.mouseup(event => this.getOptStateDelegate().getCurrentState().mouseup(event));
        paper.mousemove(event => this.getOptStateDelegate().getCurrentState().mousemove(event));

    }

    //根据鼠标点击位置确定所在区域
    hitCell(x: number, y: number, selectField: string | null, index: number): FieldRow | undefined {
        let list;
        if(selectField == CommonConstant.Type_Source_SourceTable){
            list = this.sourceViewElements;
        }else if(selectField == CommonConstant.Type_Source_TargetTable){
            list = this.targetViewElements;
        }else if(selectField == CommonConstant.Type_Source_FeedBackTable){
            list = this.feedbackViewElements.get(index);
        }else{
            return undefined;
        }

        for(let element of list){
            if(!element.containPoint(x, y)) continue;
            let elementOffset = DomUtil.offsetParent(element.getEl());
            let offsetX = x - elementOffset.offsetLeft;
            let offsetY = y - elementOffset.offsetTop;
            let fieldRow = element.locRow(offsetX, offsetY);
            if(fieldRow) {
                return fieldRow;
            }
        }
        return undefined;

    }

    getSourceViews(): Map<string, DataMapSourceTableView> {
        return this.sourceViews;
    }

    getTargetViews(): Map<string, DataMapTargetTableView> {
        return this.targetViews;
    }

    getFeedbackViews(): Map<string, DataMapFeedbackView> {
        return this.feedbackViews;
    }




    getTemplateView(): JComponent<any>{
        if (this.selectViewName == CommonConstant.Type_Source_SourceTable) {
            return this.stcView;
        } else {
            return this.ttcView;
        }

    }

    getFeedBackTemplateView(index: number):  JComponent<any>{
        return this.ftcViewList.get(index);
    }



    getXmlEntity(){
        return this.xmlEntity;
    }

    setSelectViewName(name: string) {
        this.selectViewName = name;
    }

    setSelectFieldView(fieldRow: FieldRow): void {
        this.selectFieldRow = fieldRow;
        this.selectFieldTagNode = fieldRow.getTagNode();
    }


    getSelectFieldView(): FieldRow | undefined {
        return this.selectFieldRow;
    }

    getSelectFieldTagNode(): ITagNode | undefined {
        if (!this.selectFieldTagNode){
            return this.selectFieldRow?.getTagNode();
        }
        return this.selectFieldTagNode;
    }

    getSrcForeignObject(): SVGForeignObjectElement {
        return this.srcForeignObject!;
    }

    getTgtForeignObject(): SVGForeignObjectElement {
        return this.tagForeignObject!;
    }

    getFdbForeignObject(index : number): SVGForeignObjectElement {
        return this.feedbackForeignObjectList.get(index)!;
    }
    setSelectFieldTagNode(iTagNode: ITagNode): void {
        this.selectFieldTagNode = iTagNode;
    }

    setSelectSourceView(sourceView:DataMapSourceTableView){
        this.selectSourceView = sourceView;
    }

    getSelectSourceView(): DataMapSourceTableView | undefined {
        return this.selectSourceView;
    }

    setSelectTargetView(targetView:DataMapTargetTableView){
        this.selectTargetView = targetView;
    }

    getSelectTargetView(): DataMapTargetTableView | undefined {
        return this.selectTargetView;
    }

    getSelectFeedBackView(): DataMapFeedbackView | undefined {
        return this.selectFeedBackView;
    }

    setSelectFeedBackView(feedBackView:DataMapFeedbackView){
        this.selectFeedBackView = feedBackView;
    }

    getSrcPoint(): Map<string, DivElement> {
        return this.scrPoints;
    }

    getTarPoint(): Map<string, DivElement> {
        return this.tarPoints;
    }

    getTarRightPoint(): Map<string, DivElement> {
        return this.tarRightPoints;
    }

    getFeedbackPoint(index: number): Map<string, DivElement> {
        return this.feedbackPointList.get(index);
    }

    setSelectFieldRow(fieldRow: FieldRow): void {
        this.selectFieldRow = fieldRow;
        this.selectFieldTagNode = fieldRow.getTagNode();
    }

    getPaper(): GDataMigration {
        return this.paper;
    }

    getCmdQueue(): CmdQueue {
        return this.xmlEntity.getCmdQueue();
    }

    getStcView() {
        return this.stcView;
    }

    getTtcView() {
        return this.ttcView;
    }

    getFtcViewList() {
        return this.ftcViewList;
    }

    getGridBorder(): BorderPanel {
        return this.gridBorder;
    }

    getMapLinks(): Map<String, Link> {
        return this.mapLinks;
    }

    // 移动table
    public doMoveTableCmd(dataMapGraphicView: DataMapGraphicView, tagNode: ITagNode, x: number, y: number): any {
        let cmd = new MoveDataMapTableCmd(dataMapGraphicView.getXmlEntity(), tagNode, x, y);
        this.getCmdQueue().doCmd(cmd);
    }

    //连线
    public doNewLinkCmd(dataMapGraphicView: DataMapGraphicView, fromNode: ITagNode, toNode: ITagNode): any {
        let cmd = new AddLinkCmd(dataMapGraphicView.getXmlEntity(), fromNode, toNode);
        this.getCmdQueue().doCmd(cmd);
    }

    // 交换Field
    public doMoveFieldCmd(dataMapGraphicView: DataMapGraphicView, fromNode: ITagNode, toNode: ITagNode): any {
        let cmd = new DataMapMoveFieldCmd(dataMapGraphicView.getXmlEntity(), fromNode, toNode);
        this.getCmdQueue().doCmd(cmd);
    }

    //修改字段内容
    initInputState(dataMapGraphicView: DataMapGraphicView, e: any) {
        let cmd = new ModifyFieldAttrCmd(dataMapGraphicView, e);
        this.getCmdQueue().doCmd(cmd);
    }

    //删除字段
    initDeleteState(dataMapGraphicView: DataMapGraphicView, e: any) {
        let cmd = new DeleteFieldRowCmd(dataMapGraphicView, e);
        this.getCmdQueue().doCmd(cmd);
    }

    //删除线
    public doDeleteLinkCmd(dataMapGraphicView: DataMapGraphicView, tagNode: ITagNode , parentNode: ITagNode | undefined): any {
        let cmd = new DeleteLinkCmd(dataMapGraphicView, tagNode , parentNode);
        this.getCmdQueue().doCmd(cmd);
    }

    addSourceFieldCmd(dataMapGraphicView: DataMapGraphicView, tableKey: string, fieldKey: string, tagNode: ITagNode){
        let cmd = new AddSourceFieldCmd(dataMapGraphicView, tableKey, fieldKey, tagNode);
        this.getCmdQueue().doCmd(cmd);
    }

    addTargetFieldCmd(dataMapGraphicView: DataMapGraphicView, tableKey: string, fieldKey: string, tagNode: ITagNode){
        let cmd = new AddTargetFieldCmd(dataMapGraphicView, tableKey, fieldKey, tagNode);
        this.getCmdQueue().doCmd(cmd);
    }

    addFeedBackFieldCmd(dataMapGraphicView: DataMapGraphicView, tableKey: string, fieldKey: string, tagNode: ITagNode){
        let cmd = new AddFeedBackFieldCmd(dataMapGraphicView, tableKey, fieldKey, tagNode);
        this.getCmdQueue().doCmd(cmd);
    }

    /**
     * 弹窗批量添加源字段
     */
    addSourceFieldsCmd(dataTable: any, xmlEntity: IXmlEntity, wfWorkSpace: IWorkSpace){
        let cmd = new AddSourceFieldsCmd(dataTable, xmlEntity, wfWorkSpace);
        this.getCmdQueue().doCmd(cmd);
    }

    addTargetFieldsCmd(dataTable: any, xmlEntity: IXmlEntity, wfWorkSpace: IWorkSpace){
        let cmd = new AddTargetFieldsCmd(dataTable, xmlEntity, wfWorkSpace);
        this.getCmdQueue().doCmd(cmd);
    }

    addFeedBackFieldsCmd(dataTable: any, xmlEntity: IXmlEntity, wfWorkSpace: IWorkSpace, formKey:string){
        let cmd = new AddFeedBackFieldsCmd(dataTable, xmlEntity, wfWorkSpace, formKey);
        this.getCmdQueue().doCmd(cmd);
    }

}