import ComplexDesignView from "../../base/ComplexDesignView";
import Toolbar from "../../../common/component/toolbar/Toolbar";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import DesignVariable from "../../base/DesignVariable";
import PropertyUIContainer from "../../plugin/property/ui/PropertyUIContainer";
import DevPropertyPlugin from "../../bpm/property/DevPropertyPlugin";
import AbstractDesignView from "../../base/AbstractDesignView";
import PropertyPlugin from "../../plugin/property/PropertyPlugin";
import {DataMapGraphicView} from "./DataMapGraphicView";
import {DataMapPropertyDefine} from "../base/DataMapPropertyDefine";
import DataMigrationConstants from "../../datamigration/base/DataMigrationConstants";
import {CommonConstant} from "../base/CommonConstant";
import SizeInfo from "../../../common/struct/SizeInfo";

export class DataMapDesignView extends AbstractDesignView<DevPropertyPlugin>{

    private viewContainer: ComplexDesignView<DataMapGraphicView, Toolbar>;

    private propertyPlugin: PropertyPlugin;

    constructor(viewContainer: ComplexDesignView<any, Toolbar>, optDispatcher: OperationDispatcher){
        super(DesignVariable.D_PROPERTY_WIDTH, new PropertyUIContainer(new DevPropertyPlugin(optDispatcher)));
        this.viewContainer = viewContainer;
        this.propertyPlugin = this.propertyUIContainer.getPropertyPlugin();

        this.propertyUIContainer.setStyle('float', 'right');
        this.setCenter(viewContainer);
        this.setRight(this.propertyUIContainer);
        let instance = DataMapPropertyDefine.getInstance();
        this.propertyPlugin.register(CommonConstant.NODE_DataMap, instance.getPropertyDefines(CommonConstant.NODE_DataMap));
        this.propertyPlugin.register(CommonConstant.NODE_SourceTableCollection, instance.getPropertyDefines(CommonConstant.NODE_SourceTableCollection));
        this.propertyPlugin.register(CommonConstant.NODE_SourceTable, instance.getPropertyDefines(CommonConstant.NODE_SourceTable));
        this.propertyPlugin.register(CommonConstant.NODE_SourceField, instance.getPropertyDefines(CommonConstant.NODE_SourceField));
        this.propertyPlugin.register(CommonConstant.NODE_TargetTableCollection, instance.getPropertyDefines(CommonConstant.NODE_TargetTableCollection));
        this.propertyPlugin.register(CommonConstant.NODE_TargetTable, instance.getPropertyDefines(CommonConstant.NODE_TargetTable));
        this.propertyPlugin.register(CommonConstant.NODE_TargetField, instance.getPropertyDefines(CommonConstant.NODE_TargetField));
        this.propertyPlugin.register(CommonConstant.NODE_FeedbackObject, instance.getPropertyDefines(CommonConstant.NODE_FeedbackObject));
        this.propertyPlugin.register(CommonConstant.NODE_FeedbackTable, instance.getPropertyDefines(CommonConstant.NODE_FeedbackTable));
        this.propertyPlugin.register(CommonConstant.NODE_FeedbackField, instance.getPropertyDefines(CommonConstant.NODE_FeedbackField));
        this.propertyPlugin.register(CommonConstant.NODE_FEEDBACK, instance.getPropertyDefines(CommonConstant.FeedLigature));
        this.propertyPlugin.register(CommonConstant.VestLigature, instance.getPropertyDefines(CommonConstant.VestLigature));
        this.propertyPlugin.register("Ligature", instance.getPropertyDefines("Ligature"));
    }

    resize(parentWidth: number, parentHeight: number) {
        var width = parentWidth -  DesignVariable.D_PROPERTY_WIDTH;
        this.viewContainer.resize(width, parentHeight);
        this.propertyUIContainer.setHeight(SizeInfo.valueOfPX(parentHeight));
    }

}