import {DataMapOptStateDelegate} from "./DataMapOptStateDelegate";
import {AbstractDataMapOptState} from "./AbstractDataMapOptState";
import ITagNode from "../../../common/xml/node/ITagNode";
import TagNode from "../../../common/xml/node/TagNode";
import {CommonConstant} from "../base/CommonConstant";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";

export class DataMapNormalState extends AbstractDataMapOptState{
    private fromTag?: ITagNode;
    private toNodeKey?: ITagNode;
    private operationDispatcher?: OperationDispatcher;

    constructor(optStateDelegate: DataMapOptStateDelegate){
        super(optStateDelegate);
    }

    setOperationDispatcher (operationDispatcher: OperationDispatcher){
        this.operationDispatcher = operationDispatcher;
    }

    mousemove(e: MouseEvent): void {
        let view = this.findFieldView(e);
        if (view) { // 转发到字段操作状态
            this.getDelegate().setFieldOptState();
        }
    }

    mousedown(e: MouseEvent) {
        let selectionModel = this.getView().getXmlEntity().getSelectionModel();
        let target = <HTMLElement>e.target;

        // 点击的是连接线
        if (target.tagName == "path") {
            // 连接线
            let elHTMLElement = <HTMLElement>e.target;
            const el = $(elHTMLElement);
            el.addClass("fieldCell_pointer");
            let type = target.getAttribute('type');
            let pathId = target.getAttribute('pathId');
            if (!pathId) return; // 点击的箭头
            let srcTableKey = target.getAttribute('srcTableKey');
            let tagTableKey = target.getAttribute('targetTableKey');
            let tagRoot = this.getView().getXmlEntity().getTagRoot();
            let result:ITagNode = new TagNode("");
            let parent: ITagNode |undefined;

            if (type == "normal") {
                if (pathId) {
                    let fields = pathId!.split("*_*");
                    let src_field = fields[1];
                    let tag_field = fields[3];
                    let child = <ITagNode>tagRoot.find(CommonConstant.NODE_SourceTableCollection, "", "");
                    let findSourceTable = child.find(CommonConstant.NODE_SourceTable, CommonConstant.NODE_Table_Key, srcTableKey!);

                    // 获取xml中sourceTable中对应node
                    findSourceTable!.getChildren().forEach((node, i, ii) => {
                        let node1 = <ITagNode>(node);
                        if(node1.getAttributeValue(CommonConstant.S_Key) == target.getAttribute(CommonConstant.S_Key) && node1.getAttributeValue("TargetFieldKey", "") == tag_field){
                            result = node1;
                        }
                    })
                    if (e.button == 2) {
                        this.delete(result, parent);
                    }
                    else {
                        if (result != null) {
                            // selectionModel.select(this.getView().getXmlEntity().getTagRoot());
                            let ligature = new TagNode("Ligature");
                            ligature.setAttributeValue("TargetTableKey", tagTableKey!);
                            ligature.setAttributeValue("TargetFieldKey", tag_field!);
                            ligature.setAttributeValue("TargetFieldCaption", target.getAttribute("targetFieldCaption")!);
                            ligature.setAttributeValue("TableKey", srcTableKey!);
                            ligature.setAttributeValue("Caption", target.getAttribute("sourceFieldCaption")!);
                            ligature.setAttributeValue("FieldKey", src_field!);
                            ligature.setAttributeValue("Key", target.getAttribute(CommonConstant.S_Key)!);
                            ligature.setAttributeValue("Editable", (<ITagNode>result).getAttributeValue("Editable", "true"));
                            let edgeType = (<ITagNode>result).getAttributeValue("EdgeType", "Normal");
                            ligature.setAttributeValue("EdgeType", edgeType);
                            if(edgeType == CommonConstant.EdgeType_Normal) {
                                ligature.setAttributeValue("Condition", (<ITagNode>result).getAttributeValue("Condition", ""));
                            }else if(edgeType == CommonConstant.EdgeType_Focus){
                                ligature.setAttributeValue("IsNegtive", (<ITagNode>result).getAttributeValue("IsNegtive", "false"));
                            }
                            ligature.getChildren().push(result);
                            selectionModel.select(ligature);
                            let mapLinks = this.getView().getMapLinks();
                            // @ts-ignore 连接线加粗
                            $(mapLinks.get(pathId).group.line.paper.node).css("stroke-width", "3");
                        }
                    }
                }
            } else if (type == "feedBack") {// 反填连接线
                let fields = pathId!.split("*_*");
                let tag_field = fields[1];
                let feed_field = fields[3];
                let feedFormKey = target.getAttribute(CommonConstant.NODE_FeedFormKey);
                let tableKey = target.getAttribute(CommonConstant.NODE_FeedbackTableKey);

                let child = <ITagNode>this.getView().getXmlEntity().getRoot().find(CommonConstant.NODE_TargetTableCollection, "", "");


                let findTargetTable = child.find(CommonConstant.NODE_TargetTable, CommonConstant.NODE_Table_Key, tagTableKey!);

                // 获取xml中sourceTable中对应node
                findTargetTable!.getChildren().forEach((node, i, ii) => {
                    let node1 = <ITagNode>(node);
                    if (node1.getChildren().length > 0) {
                        node1.getChildren().forEach((feedbackNode, i) => {
                            let feedbackNode1 = <ITagNode>feedbackNode;
                            if(node1.getAttributeValue(CommonConstant.NODE_Definition, "") == tag_field &&
                                feedbackNode1.getAttributeValue(CommonConstant.NODE_FeedFormKey, "") == feedFormKey &&
                                feedbackNode1.getAttributeValue(CommonConstant.NODE_FeedbackTableKey, "") == tableKey &&
                                feedbackNode1.getAttributeValue(CommonConstant.NODE_FieldKey, "") == feed_field){
                                result = feedbackNode1;
                                parent = node1;
                            }
                        });
                    }
                });
                if (e.button == 2) {
                    this.delete(result, parent);
                }
                else {
                    if (result) {
                        let ligature = new TagNode(CommonConstant.NODE_FEEDBACK);
                        ligature.setAttributeValue("FeedFormKey", target.getAttribute(CommonConstant.NODE_FeedFormKey)!);
                        ligature.setAttributeValue("TableKey", target.getAttribute("targetTableKey")!);
                        ligature.setAttributeValue("FieldKey", target.getAttribute(CommonConstant.NODE_FieldKey)!);
                        ligature.setAttributeValue("FeedFieldCaption", target.getAttribute("FeedFieldCaption")!);
                        ligature.setAttributeValue("TargetFieldKey", target.getAttribute("TargetFieldKey")!);
                        ligature.setAttributeValue("TargetFieldCaption", target.getAttribute("TargetFieldCaption")!);
                        ligature.setAttributeValue("OpSign", target.getAttribute(CommonConstant.NODE_OpSign)!);
                        ligature.setAttributeValue("PostTrigger", target.getAttribute(CommonConstant.NODE_PostTrigger)!);
                        ligature.setAttributeValue("PostFormulaTrigger", target.getAttribute(CommonConstant.NODE_PostFormulaTrigger)!);
                        ligature.setAttributeValue("Condition", target.getAttribute(CommonConstant.NODE_Condition)!);
                        ligature.getChildren().push(result);
                        selectionModel.select(ligature);
                        let mapLinks = this.getView().getMapLinks();
                        // @ts-ignore 连接线加粗
                        $(mapLinks.get(pathId).group.line.paper.node).css("stroke-width", "3");
                    }
                }

            }


            return;
        }else {
            // 点击的是字段视图
            let findFieldView = this.findFieldView(e)!;
            if (!findFieldView) {
                // 点击的是工作区域背景
                if (target.tagName == "svg") {
                    selectionModel.select(this.getView().getXmlEntity().getTagRoot());
                }
                return;
            }
            let tagNode = findFieldView.getTagNode();
            this.getView().setSelectFieldView(findFieldView);
            selectionModel.select(tagNode);
        }

    }

    mouseup(e: MouseEvent): void {

    }

    reset(): void {
        super.reset();
        this.fromTag = undefined;
        this.toNodeKey = undefined;
    }

    delete( result: ITagNode, parent: ITagNode | undefined ) {
        if (result != null) {
            document.oncontextmenu = function () {
                return false;
            }
            // @ts-ignore
            let layer = layui.layer;
            layer.confirm('确认删除连接线？', {
                icon: 3,
                title: '提示',
                cancel: () => {
                }
                // @ts-ignore
            }, (index, layero) => {
                this.getView().doDeleteLinkCmd(this.getView(), result, parent);
                layer.close(index);//需要手动关闭
            }, () => {
            });

        }
    }

}