import {AbstractDataMapOptState} from "./AbstractDataMapOptState";
import {DataMapOptStateDelegate} from "./DataMapOptStateDelegate";
import {FieldRow} from "../view/element/FieldRow";
import {CommonConstant} from "../base/CommonConstant";
import DomUtil from "../../../common/dom/DomUtil";
import DivElement from "../../../common/dom/element/DivElement";
import ITagNode from "../../../common/xml/node/ITagNode";
import {CommonFunction} from "../base/CommonFunction";
import DomElement from "../../../common/dom/element/DomElement";
import ArrayList from "../../../common/struct/ArrayList";

export class DataMapNewLinkState extends AbstractDataMapOptState{
    private fromRow?: FieldRow;
    private toRow?: FieldRow;

    constructor(delegate: DataMapOptStateDelegate){
        super(delegate);
    }

    mousedown(e: MouseEvent): void {
        let view = this.findFieldView(e);
        if (!view) return;
    }

    mousemove(e: MouseEvent): void {
        let currentTarget = <HTMLElement>e.currentTarget;
        if (!this.fromRow) return;
        let findFieldView = this.findFieldView(e);
        if (findFieldView) {
            let node = findFieldView.getTagNode();
            if (node.getTagName() == CommonConstant.NODE_TargetField) {
                let tarPoint = this.getView().getTarPoint();
                let fieldKey = node.getAttributeValue(CommonConstant.NODE_Definition);
                let tableKey = node.getParent()!.getAttributeValue(CommonConstant.NODE_Table_Key);
                let tarPos = tarPoint.get(tableKey + "_" + fieldKey);
                this.ensureShadowLink().drawShadowToLink({
                    x: tarPos!.getOffsetLeft(),
                    y: tarPos!.getOffsetTop() - 30,
                    width: 4,
                    height: 4
                });
                return;
            }
            if (node.getTagName() == CommonConstant.NODE_FeedbackField) {
                let target = CommonFunction.getSelectTarget(e);
                let index = target.getAttribute(CommonConstant.TYPE_FeedbackIndex);
                if(!index) return;
                let feedbackPoint = this.getView().getFeedbackPoint(Number.parseInt(index));
                let feedTableKey = node.getParent()!.getAttributeValue(CommonConstant.NODE_FeedbackTableKey);
                let fieldKey = node.getAttributeValue(CommonConstant.NODE_FieldKey);
                let feedbackPos = feedbackPoint.get(feedTableKey + "_" + fieldKey);
                this.ensureShadowLink().drawShadowToLink({
                    x: feedbackPos!.getOffsetLeft(),
                    y: feedbackPos!.getOffsetTop() - 30,
                    width: 4,
                    height: 4
                });
                return;
            }
        }
        
        let offsetBodyPosition = DomUtil.offsetBodyPosition(new DomElement(currentTarget).getEl());
        this.ensureShadowLink().drawShadowToLink({
            x: e.x - offsetBodyPosition.offsetBodyLeft,
            y: e.y - offsetBodyPosition.offsetBodyTop,
            width: 4,
            height: 4
        });
    }

    mouseup(e: MouseEvent): void {
        let findFieldView = this.findFieldView(e);
        if(!findFieldView){
            this.reset();
            return;
        }
        let tagNode = findFieldView.getTagNode();
        if(!this.toRow && tagNode){
            this.toRow = findFieldView;
        }
        if(this.fromRow && this.toRow){
            let root = this.fromRow.getTagNode().getParent()!.getParent()!.getParent();
            if(root!.hasAttribute(CommonConstant.ATTR_Extend)){
                let fromTag = this.fromRow.getTagNode();
                let toTag = this.toRow.getTagNode();
                if(this.fromRow.getTagNode().getTagName() == CommonConstant.NODE_SourceField){
                    let extendSourceToTargetLinks = this.getView().getExtendSourceToTargetLinks();
                    if(extendSourceToTargetLinks &&  extendSourceToTargetLinks.length > 0){
                        let fieldKey;
                        if(fromTag.hasAttribute(CommonConstant.NODE_Definition)){
                            fieldKey = fromTag.getAttributeValue(CommonConstant.NODE_Definition);
                        }else{
                            fieldKey = fromTag.getAttributeValue(CommonConstant.S_Key);
                        }
                        let sourceTableKey = fromTag.getParent()!.getAttributeValue(CommonConstant.S_Key);
                        let targetFieldKey = toTag.getAttributeValue(CommonConstant.NODE_Definition);
                        let targetTableKey = toTag.getParent()!.getAttributeValue(CommonConstant.S_Key);
                        let link = sourceTableKey + "*" + fieldKey + "--" + targetTableKey + "*" + targetFieldKey;
                        if(extendSourceToTargetLinks.indexOf(link) > -1){
                            this.reset();
                            // @ts-ignore
                            layui.layer.msg("检测到关联数据映射已存在此映射边，不允许重复添加！", {icon: 5, time:2000});
                            return;
                        }
                    }

                }
                if(this.fromRow.getTagNode().getTagName() == CommonConstant.NODE_TargetField){
                    let extendTargetToFeedbackLinks = this.getView().getExtendTargetToFeedbackLinks();
                    if(extendTargetToFeedbackLinks &&  extendTargetToFeedbackLinks.length > 0){
                        let fieldKey = fromTag.getAttributeValue(CommonConstant.NODE_Definition);
                        let targetTableKey = fromTag.getParent()!.getAttributeValue(CommonConstant.S_Key);
                        let feedDataObjectKey = toTag.getParent()!.getParent()!.getAttributeValue(CommonConstant.ATTR_ObjectKey);
                        let feedTableKey = toTag.getParent()!.getAttributeValue(CommonConstant.ATTR_TableKey);
                        let feedFieldKey = toTag.getAttributeValue(CommonConstant.ATTR_FieldKey);
                        let link = targetTableKey + "*" + fieldKey + "--" + feedDataObjectKey + "*" + feedTableKey + "*" + feedFieldKey;
                        if(extendTargetToFeedbackLinks.indexOf(link) > -1){
                            this.reset();
                            // @ts-ignore
                            layui.layer.msg("检测到关联数据映射已存在此映射边，不允许重复添加！", {icon: 5, time:2000});
                            return;
                        }
                    }
                }
            }
            let fromRowDataType = this.fromRow.getDataType();
            let toRowDataType = this.toRow.getDataType();
            if(fromRowDataType == "") {
                this.getView().doNewLinkCmd(this.getView(), this.fromRow.getTagNode(), this.toRow.getTagNode());
            }else{
                if(fromRowDataType == toRowDataType){
                    this.getView().doNewLinkCmd(this.getView(), this.fromRow.getTagNode(), this.toRow.getTagNode());
                }else{
                    this.reset();
                    // @ts-ignore
                    layui.layer.msg("数据类型不匹配，不支持此操作！", {icon: 5, time:5000});
                }
            }
        }
        this.reset();
    }

    setFromEl(row: FieldRow, e: MouseEvent): void{
        let tagNode = row.getTagNode();
        if(tagNode.getTagName() == CommonConstant.NODE_SourceField) {
            let srcPoint = this.getView().getSrcPoint();
            this.createFromNode(srcPoint, row, tagNode, e);
        }else if(tagNode.getTagName() == CommonConstant.NODE_TargetField){
            let tarRightPoint = this.getView().getTarRightPoint();
            this.createFromNode(tarRightPoint, row, tagNode, e);
        }
    }

    createFromNode(points: Map<string, DivElement>, row: FieldRow, tagNode: ITagNode, e: MouseEvent){
        let fieldKey = CommonFunction.getSourceFieldValue(tagNode);
        let tableKey = tagNode.getParent()!.getAttributeValue(CommonConstant.NODE_Table_Key);
        let Pos = points.get(tableKey + "_" + fieldKey);
        if(!Pos) return;
        this.getView().setSelectFieldRow(row);
        if (!this.fromRow && tagNode) {
            this.fromRow = row;
            this.setFromNode(e, Pos!.getOffsetLeft(), Pos!.getOffsetTop() - 30);
        }
    }

    setFromNode(e: MouseEvent, x: number, y: number) {
        this.ensureShadowLink().setFromNode({x: x, y: y, width: 4, height: 4},0);
    }

    reset(): void {
        super.reset();
        this.fromRow = undefined;
        this.toRow = undefined;
    }
}