import {AbstractDataMapOptState} from "./AbstractDataMapOptState";
import {DataMapOptStateDelegate} from "./DataMapOptStateDelegate";
import {FieldRow} from "../view/element/FieldRow";
import {CommonConstant} from "../base/CommonConstant";

export class DataMapMoveFieldState extends AbstractDataMapOptState {
    private fromTag?: FieldRow;

    constructor(delegate: DataMapOptStateDelegate){
        super(delegate);
    }

    mousedown(e: MouseEvent): void {
       let findFieldView = this.findFieldView(e);
       if(!findFieldView) return;
    }

    mousemove(e: MouseEvent): void {

    }

    mouseup(e: MouseEvent): void {
        if(this.fromTag){
            let findFieldView = this.findFieldView(e);
            if(findFieldView){
                if(this.fromTag.getTagNode() != findFieldView.getTagNode()){
                    let fromNode = this.fromTag.getTagNode();
                    let toNode = findFieldView.getTagNode();
                    if(fromNode.getTagName() == CommonConstant.NODE_FeedbackField || fromNode.getTagName() == CommonConstant.NODE_FeedbackObject){
                        if(fromNode.getParent()!.getAttributeValue(CommonConstant.NODE_FeedbackTableKey) == toNode.getParent()!.getAttributeValue(CommonConstant.NODE_FeedbackTableKey)){
                            this.getView().doMoveFieldCmd(this.getView(), fromNode, toNode);
                        }
                    }else {
                        if (fromNode.getParent()!.getAttributeValue(CommonConstant.NODE_Table_Key) == toNode.getParent()!.getAttributeValue(CommonConstant.NODE_Table_Key)) {
                            this.getView().doMoveFieldCmd(this.getView(), fromNode, toNode);
                        }
                    }
                }
            }
        }
        this.getDelegate().setNormalState();
    }

    setFromEl(fieldRow: FieldRow): void {
        let node = fieldRow.getTagNode();
        this.getView().setSelectFieldView(fieldRow);
        if (!this.fromTag && node) {
            this.fromTag = fieldRow;
            return;
        }
    }
}