import AbstractOptState from "../../../common/state/AbstractOptState";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import {DataMapOptStateDelegate} from "./DataMapOptStateDelegate";
import {FieldRow} from "../view/element/FieldRow";
import {CommonConstant} from "../base/CommonConstant";
import {DataMapShadowLink} from "../view/element/shadow/DataMapShadowLink";
import DomUtil from "../../../common/dom/DomUtil";
import {CommonFunction} from "../base/CommonFunction";

export class AbstractDataMapOptState extends AbstractOptState<DataMapGraphicView,DataMapOptStateDelegate>{
    protected shadowLink!: DataMapShadowLink | undefined;

    constructor(optStateDelegate:DataMapOptStateDelegate){
        super(optStateDelegate);
    }

    getViewEl(): HTMLElement {
        return this.getDelegate().getView().getTemplateView().getEl();
    }

    getFeedbackEl(index: number): HTMLElement{
        return this.getDelegate().getView().getFeedBackTemplateView(index).getEl();
    }


mousemove(e: MouseEvent): void {
    }

    findFieldView(e: MouseEvent): FieldRow | undefined{
        let target = CommonFunction.getSelectTarget(e);
        let selectField = target.getAttribute(CommonConstant.TYPE_SOURCE);
        let hitFieldView;
        if(selectField == CommonConstant.Type_Source_SourceTable){
            this.getView().setSelectViewName(CommonConstant.Type_Source_SourceTable);
            let {x,y} = this.getPosition(e);
            hitFieldView = this.getView().hitCell(x, y, selectField, 0);
        }else if(selectField == CommonConstant.Type_Source_TargetTable){
            this.getView().setSelectViewName(CommonConstant.Type_Source_TargetTable);
            let {x,y} = this.getPosition(e);
            hitFieldView = this.getView().hitCell(x, y, selectField, 0);
        }else if(selectField == CommonConstant.Type_Source_FeedBackTable){
            this.getView().setSelectViewName(CommonConstant.Type_Source_FeedBackTable);
            let index = target.getAttribute(CommonConstant.TYPE_FeedbackIndex);
            if(!index){
                return undefined;
            }
            let {x,y} = this.getFeedbackPosition(e,Number.parseInt(index));
            hitFieldView = this.getView().hitCell(x, y, selectField, Number.parseInt(index));
        }
        return hitFieldView;
    }

    protected ensureShadowLink(): DataMapShadowLink {
        if (this.shadowLink) return this.shadowLink;
        this.shadowLink = new DataMapShadowLink();
        this.shadowLink.initGSection(this.getView().getPaper().section());
        return this.shadowLink;
    }

    reset(): void {
        this.shadowLink?.remove();
        this.shadowLink = undefined;
        this.getDelegate().reset();
    }

    protected getFeedbackPosition(e: MouseEvent, index: number): {x: number, y: number}{
        let {offsetBodyLeft, offsetBodyTop} = this.getFeedbackOffsetFromBody(index);
        let {parentoffsetTop, parentOffsetLeft} = this.getScrollOffset(<HTMLElement> e.target, this.getFeedbackEl(index));
        let x = e.clientX - offsetBodyLeft + parentOffsetLeft;
        let y = e.clientY - offsetBodyTop + parentoffsetTop;
        return {x: x, y: y}
    }

    private getFeedbackOffsetFromBody(index: number): {offsetBodyLeft: number, offsetBodyTop: number} {
        return DomUtil.offsetBodyPosition(this.getFeedbackEl(index));
    }


}