import AbstractDomElement from "../../../common/dom/AbstractDomElement";
import Events from "../../../common/event/Events";
import {CommonConstant} from "../base/CommonConstant";
import ITagNode from "../../../common/xml/node/ITagNode";
import SizeInfo from "../../../common/struct/SizeInfo";
import Menu from "../../../common/component/menu/Menu";
import {DataMapFeedbackView} from "../view/DataMapFeedbackView";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import KeyUpEvent = JQuery.KeyUpEvent;
import OperationDispatcher from "../../../common/operation/OperationDispatcher";

export class FeedbackEventListener {

    private graphicView: DataMapGraphicView;
    private operationDispatcher: OperationDispatcher;
    private mune: Menu | undefined;

    constructor(graphicView: DataMapGraphicView, operationDispatcher: OperationDispatcher){
        this.graphicView = graphicView;
        this.operationDispatcher = operationDispatcher;
    }

    initFeedBackEvent(ftcViewDom: AbstractDomElement, index:number) {
        ftcViewDom.addEventListener(Events.MouseDown, (e: MouseEvent) => {
            let target = <HTMLElement>e.target;
            if (target.nodeName == CommonConstant.Node_Type_Span) {
                if (target.className.indexOf("selectImg") != -1) {
                    this.getFdbDataBySelectImg(target, index);
                } else if (target.className.indexOf("textArea") != -1) {
                    this.addInputFeedBackField(target, index);
                }
            } else if (target.nodeName == CommonConstant.Node_Type_Input && target.className.indexOf("addButton_Head") != -1) {
                let attribute = target.getAttribute(CommonConstant.NODE_FormKey);
                if (!attribute) {
                    attribute = target.getAttribute(CommonConstant.NODE_Table_Key);
                }
                let feedBackViews = this.graphicView.getFeedbackViews();
                let feedbackView = feedBackViews.get(attribute!);
                if (feedbackView) {
                    this.graphicView.setSelectFeedBackView(feedbackView);
                    var isTitle = feedbackView.isTableTitle();
                    let tableKey = "";
                    let formKey;
                    let dataSource = "";
                    if (isTitle) {
                        formKey = attribute;
                    } else {
                        formKey = attribute!.split("|")[0];
                        tableKey = attribute!.split("|")[1];
                    }
                    let formula = `Macro_ShowFieldList('${isTitle}', '${formKey}' ,'${tableKey}', '${dataSource}', 'feedback')`;
                    this.operationDispatcher.eval(formula);
                }
            }
        });
    }

    getFdbDataBySelectImg(target: HTMLElement, index: number) {
        let value, formula;
        if (target.getAttribute(CommonConstant.NODE_FormKey)) {
            value = target.getAttribute(CommonConstant.NODE_FormKey);
            formula = `Macro_GetFormAllField('${value}','','')`;
        } else {
            value = target.getAttribute(CommonConstant.NODE_Table_Key);
            formula = `Macro_GetTableFields('${value!.split("|")[0]}','${value!.split("|")[1]}','','')`;
        }
        let fdbViews = this.graphicView.getFeedbackViews();
        let fdbView = fdbViews.get(value!);
        if (!fdbView) return;
        this.graphicView.setSelectFeedBackView(fdbView);
        let menu = fdbView!.getMenu();
        menu.addEventListener("focus", (e: any) => {
            this.graphicView.getOptStateDelegate().setInputFieldState()
        });
        var self = this;
        menu.addEventListener("blur", (e: any) => {
            self.graphicView.getOptStateDelegate().setNormalState()
        });
        this.parseFieldDataToFdbMenu(menu, formula, fdbView, target);
    }

    addInputFeedBackField(target: HTMLElement, index: number) {
        let graphicView = this.graphicView;

        // title 和 table的输入框获取的attribute不一样
        let attribute = target.getAttribute(CommonConstant.NODE_FormKey);
        if (!attribute) {
            attribute = target.getAttribute(CommonConstant.NODE_Table_Key);
        }
        let feedbackViews = graphicView.getFeedbackViews();
        var feedbackView = feedbackViews.get(attribute!);
        if (!feedbackView) return;
        let inputPrompt = feedbackView.getInputPromptSpan();
        inputPrompt!.setStyle("display", "none");
        feedbackView.getAddIcon().setStyle("display", "none");
        feedbackView.getInputButton()?.setStyle("display", "none");
        let addItemInput = feedbackView.getInputTextEditor();
        if (addItemInput) {
            var height = SizeInfo.valueOfPX(Number($(target).parent().height()));
            var width = SizeInfo.valueOfPX(Number($(target).parent().width()));
            addItemInput.setStyle("display", "block");
            addItemInput.setStyle("width", width);
            addItemInput.setStyle("height", "100%")
            addItemInput.setStyle("min-height", height)
            addItemInput.setStyle("disabled", "true");
            setTimeout(function () {
                addItemInput!.getEl().focus();
            }, 10);
        }
        var self = this;

        // 进行additemInput的事件初始化
        if (!feedbackView.getInitTextEditor()) {
            let addItemInputFocusFun = function () {
                self.graphicView.getOptStateDelegate().setInputFieldState();
                self.graphicView.setSelectFeedBackView(feedbackView!);
                var isTitle = feedbackView!.isTableTitle();
                let formula;
                if (isTitle) {
                    let value = target.getAttribute(CommonConstant.NODE_FormKey);
                    formula = `Macro_GetFormAllField('${value}','','')`;
                } else {
                    let value = target.getAttribute(CommonConstant.NODE_Table_Key);
                    formula = `Macro_GetTableFields('${value!.split("|")[0]}','${value!.split("|")[1]}','','')`;
                }
                let menu = feedbackView!.getMenu();
                self.parseFieldDataToFdbMenu(menu, formula, feedbackView!, target);
            }

            addItemInput!.addEventListener(Events.Focus, (e: any) => addItemInputFocusFun());

            var addItemInputBlurFun = function () {
                self.graphicView.getOptStateDelegate().setNormalState();
                setTimeout(function () {
                    feedbackView!.getMenu().hide();
                }, 10)
                feedbackView!.getAddIcon().setStyle("display", "block");
                addItemInput!.setStyle("display", "none");
                feedbackView!.getInputButton()?.setStyle("display", "block");
                inputPrompt!.setStyle("display", "block");
            }

            addItemInput!.addEventListener(Events.Blur, (e: any) => addItemInputBlurFun());

            addItemInput!.addEventListener('keyup', (e: KeyUpEvent) => {
                // ctrl v 可以搜索
                if ((!e.ctrlKey && e.code != "ControlLeft" && e.code != "ControlRight") || (e.ctrlKey && e.code == "KeyV")) {
                    if (e.code != "ArrowDown" && e.code != "ArrowUp" && e.code != "ArrowLeft" && e.code != "ArrowRight") {
                        console.log("执行了清除")
                        let menu = feedbackView!.getMenu();
                        menu.clearChildren();
                        var isTitle = feedbackView!.isTableTitle();
                        let formula;
                        if (isTitle) {
                            let value = target.getAttribute(CommonConstant.NODE_FormKey);
                            formula = `Macro_GetFormAllField('${value}','','${e.target.value}')`;
                        } else {
                            let value = target.getAttribute(CommonConstant.NODE_Table_Key);
                            formula = `Macro_GetTableFields('${value!.split("|")[0]}','${value!.split("|")[1]}','','${e.target.value}')`;
                        }
                        this.parseFieldDataToFdbMenu(menu, formula, feedbackView!, target);
                    }
                }
            });

            feedbackView.setInitTextEditor(true);
        }

    }

    parseFieldDataToFdbMenu (menu: Menu, formula:string, fdbView:DataMapFeedbackView, target: HTMLElement) {
        this.operationDispatcher.eval(formula).then((res) => {
            if (!res) return;
            if (this.mune) {
                this.mune.clearChildren();
            }
            var r = res.toString();
            let strings = r.split(";");
            this.mune = menu;
            for (let string of strings) {
                let keyAndCaption = string.split(",");
                let menuItem = menu.addMenuItem("FieldItem", keyAndCaption[1]);
                menuItem.getDomElement().setAttr("Value", keyAndCaption[0]);
                menu.setStyle("overflow", "auto");
                menuItem.addEventListener(Events.MouseDown, (event: any) => {
                    let selectFeedBackView = this.graphicView.getSelectFeedBackView();
                    if (selectFeedBackView) {
                        let tagNode = selectFeedBackView.getTagNode();
                        let value = menuItem.getDomElement().getAttr("value");
                        let keyAndValue = value!.split("|");
                        this.graphicView.addFeedBackFieldCmd(this.graphicView, keyAndValue[0], keyAndValue[1], tagNode);
                    }
                    menu.hide();
                })

            }
            // @ts-ignore
            let top = target.parentElement.parentElement.offsetParent.offsetTop
            menu.show(0, top + 60, fdbView!.getWidth().getValue(), 150, fdbView!.getEl());
            if (target.className.indexOf("selectImg") != -1) {
                menu.getEl().focus();
            }
        })
    }
}