import ICmd from "../../../common/cmd/ICmd";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import ITagNode from "../../../common/xml/node/ITagNode";
import XmlEntity from "../../../common/xml/XmlEntity";
import {CommonConstant} from "../base/CommonConstant";
import {CommonFunction} from "../base/CommonFunction";
import ArrayList from "../../../common/struct/ArrayList";

export class ModifyFieldAttrCmd implements ICmd{
    private dataMapGraphicView: DataMapGraphicView;
    private e: any;
    private oldXmlEntity?: ITagNode;

    constructor(dataMapGraphicView: DataMapGraphicView, e: any){
        this.dataMapGraphicView = dataMapGraphicView;
        this.e = e;
    }

    do(): boolean {
        let value = String($(this.e.target).val());
        let selectFieldView = this.dataMapGraphicView.getSelectFieldView();
        if (!selectFieldView) return true;
        //公式和常量字段，修改时可能存在多个xml节点需要同时修改
        let tagNode = selectFieldView!.getTagNode();
        let childs = tagNode.getParent()!.getChildren();
        let fieldKey;
        if (tagNode.getTagName() == CommonConstant.NODE_SourceField && !tagNode.hasAttribute(CommonConstant.NODE_Definition)) {
            fieldKey = tagNode.getAttributeValue(CommonConstant.S_Key);
        } else {
            fieldKey = tagNode.getAttributeValue(CommonConstant.NODE_Definition);
        }
        let root = this.dataMapGraphicView.getXmlEntity().getTagRoot().toXml(true);
        if (!CommonFunction.hasField(tagNode, value, this.dataMapGraphicView.getXmlEntity())) {
            for (let i = 0; i < childs.length; i++) {
                let findTagNode = <ITagNode>childs[i];
                if (tagNode.getTagName() == CommonConstant.NODE_SourceField) {
                    if (findTagNode.getAttributeValue(CommonConstant.S_Key) == fieldKey) {
                        findTagNode.setAttributeValue(CommonConstant.S_Key, value);
                    } else if (findTagNode.getAttributeValue(CommonConstant.NODE_Definition) == fieldKey) {
                        findTagNode.setAttributeValue(CommonConstant.NODE_Definition, value);
                        findTagNode.setAttributeValue(CommonConstant.S_Key, findTagNode.getAttributeValue(CommonConstant.S_Key, "").replace(fieldKey, value));
                    }
                } else {
                    if (findTagNode.getAttributeValue(CommonConstant.NODE_Definition) == fieldKey) {
                        findTagNode.setAttributeValue(CommonConstant.NODE_Definition, value);
                    }
                }
            }
            if (tagNode.getTagName() == CommonConstant.NODE_TargetField) {
                let tableKey = tagNode.getParent()!.getAttributeValue(CommonConstant.S_Key);
                let mapChilds = this.dataMapGraphicView.getXmlEntity().getTagRoot().getChildren();
                for (let i = 0; i < mapChilds.length; i++) {
                    let mapChild = <ITagNode>mapChilds[i];
                    if (!(mapChild.getTagName() == CommonConstant.NODE_SourceTableCollection)) continue;
                    let sourceTables = mapChild.getChildren();
                    for (let j = 0; j < sourceTables.length; j++) {
                        let sourceTable = <ITagNode>sourceTables[j];
                        let sourceFields = sourceTable.getChildren();
                        for (let k = 0; k < sourceFields.length; k++) {
                            let sourceField = <ITagNode>sourceFields[k];
                            let targetFieldKey = sourceField.getAttributeValue(CommonConstant.NODE_TargetFieldKey);
                            if (sourceField.hasAttribute(CommonConstant.NODE_TargetTableKey)) {
                                if (sourceField.getAttributeValue(CommonConstant.NODE_TargetTableKey) == tableKey && targetFieldKey == fieldKey) {
                                    sourceField.setAttributeValue(CommonConstant.NODE_TargetFieldKey, value);
                                }
                            } else {
                                if (sourceField.hasAttribute(CommonConstant.NODE_TargetFieldKey)) {
                                    if (targetFieldKey == fieldKey) {
                                        sourceField.setAttributeValue(CommonConstant.NODE_TargetFieldKey, value);
                                    }
                                }
                            }
                        }
                    }
                }
                this.dataMapGraphicView.getXmlEntity().update(this.dataMapGraphicView.getXmlEntity().getTagRoot(), true);
            } else {
                this.dataMapGraphicView.getXmlEntity().update(tagNode.getParent(), true);
            }
            this.dataMapGraphicView.getXmlEntity().getSelectionModel().select(tagNode);
            this.oldXmlEntity = XmlEntity.parseTagNode(root);
        }
        return true;
    }

    undo(): void {
        let root = this.dataMapGraphicView.getXmlEntity().getTagRoot();
        if(this.oldXmlEntity){
            root.clearChildren();
            let mapChilds =  this.oldXmlEntity.getChildren();
            for (let i = 0; i< mapChilds.length; i++){
                let mapChild = <ITagNode>mapChilds[i];
                root.addChild(mapChild);
            }
            this.dataMapGraphicView.getXmlEntity().update(root,true);
        }
    }

}