import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import XmlEntity from "../../../common/xml/XmlEntity";
import {CommonConstant} from "../base/CommonConstant";
import INode from "../../../common/xml/node/INode";

export class DeleteLinkCmd implements ICmd{
    private dataMapGraphicView: DataMapGraphicView;
    private tagNode: ITagNode;
    private oldTagNode?: ITagNode;
    private newTagNode?: ITagNode;
    private parentNode: ITagNode | undefined;

    constructor(dataMapGraphicView: DataMapGraphicView, tagNode: ITagNode, parentNode: ITagNode | undefined){
        this.dataMapGraphicView = dataMapGraphicView;
        this.tagNode = tagNode;
        this.parentNode = parentNode;
    }

    do(): boolean {
        let node = this.tagNode.toXml(true);
        if(this.parentNode && this.tagNode.getTagName() == CommonConstant.NODE_FEEDBACK){
            this.oldTagNode = XmlEntity.parseTagNode(node);
            this.parentNode.removeChild(this.tagNode);
            this.dataMapGraphicView.getXmlEntity().getSelectionModel().select(this.dataMapGraphicView.getXmlEntity().getTagRoot());
            this.newTagNode = this.tagNode;
        }else {
            this.oldTagNode = XmlEntity.parseTagNode(node);
            if(this.tagNode.hasAttribute(CommonConstant.NODE_Definition)){
                this.parentNode = this.tagNode.getParent()!;
                let count = 0;
                let definitionValue = this.tagNode.getAttributeValue(CommonConstant.NODE_Definition);
                for (let itemNode of this.parentNode.getChildren()) {
                    let attributeValue = (<ITagNode>itemNode).getAttributeValue(CommonConstant.NODE_Definition);
                    if (attributeValue === definitionValue) {
                        count++;
                    }
                }
                if (count > 1) {
                    this.parentNode.removeChild(this.tagNode);
                    this.dataMapGraphicView.getXmlEntity().getSelectionModel().select(this.dataMapGraphicView.getXmlEntity().getTagRoot());
                    this.newTagNode = this.parentNode;
                    return true;
                }
            }
            this.tagNode.removeAttribute("OpSign");
            this.tagNode.removeAttribute("GroupingPolicy");
            this.tagNode.removeAttribute("PeriodValue");
            this.tagNode.removeAttribute("MapFormula");
            this.tagNode.removeAttribute("IsNegtive");
            this.tagNode.removeAttribute("DateGranularity");
            this.tagNode.removeAttribute("TargetFieldKey");
            this.tagNode.removeAttribute("TargetTableKey");
            this.dataMapGraphicView.getXmlEntity().getSelectionModel().select(this.dataMapGraphicView.getXmlEntity().getTagRoot());
            this.newTagNode = this.tagNode;
        }
        return true;
    }

    undo(): void {
        if (!(this.oldTagNode && this.newTagNode)) return;
        if (this.parentNode) {
            this.parentNode.addChild(this.oldTagNode);
            this.dataMapGraphicView.getXmlEntity().getSelectionModel().select(this.dataMapGraphicView.getXmlEntity().getTagRoot());
        } else {
            this.newTagNode.setAttributeValue("TargetTableKey", this.oldTagNode.getAttributeValue("TargetTableKey", ""));
            this.newTagNode.setAttributeValue("TargetFieldKey", this.oldTagNode.getAttributeValue("TargetFieldKey", ""));
            this.dataMapGraphicView.getXmlEntity().getSelectionModel().select(this.dataMapGraphicView.getXmlEntity().getTagRoot());
        }
    }

}