import ICmd from "../../../common/cmd/ICmd";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import {CommonConstant} from "../base/CommonConstant";
import ITagNode from "../../../common/xml/node/ITagNode";
import XmlEntity from "../../../common/xml/XmlEntity";
import TagNode from "../../../common/xml/node/TagNode";
import ArrayList from "../../../common/struct/ArrayList";

export class DeleteFieldRowCmd implements ICmd {
    private dataMapGraphicView: DataMapGraphicView;
    private e: any;
    private oldXmlEntity?: ITagNode;
    private selectNode?: ITagNode;
    private selectNodeParentXml?: string;
    private tableKey?: string;

    constructor(dataMapGraphicView: DataMapGraphicView, e: any){
        this.dataMapGraphicView = dataMapGraphicView;
        this.e = e;
    }

    do(): boolean {
        let selectFieldViewTagNode = this.dataMapGraphicView.getSelectFieldTagNode();
        this.selectNode = selectFieldViewTagNode;
        if(!selectFieldViewTagNode) return true;
        let parent = selectFieldViewTagNode!.getParent()!;
        this.selectNodeParentXml = parent.toXml(true);
        let root = this.dataMapGraphicView.getXmlEntity().getTagRoot();
        let rootXml = root.toXml(true);
        this.oldXmlEntity = XmlEntity.parseTagNode(rootXml);
        if(selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_TargetTable || selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_FeedbackTable ||
            selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_SourceTable){
            if(selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_TargetTable){
                let tableKey = selectFieldViewTagNode?.getAttributeValue(CommonConstant.S_Key);
                this.tableKey = tableKey;
                let sourceTableCollection = root.find(CommonConstant.NODE_SourceTableCollection, "", "")!;
                for (let child of sourceTableCollection.getChildren()) {
                    let sourceTable = <TagNode>child;
                    if(sourceTable.getAttributeValue(CommonConstant.NODE_TargetTableKey) == tableKey){
                        sourceTable.removeAttribute(CommonConstant.NODE_TargetTableKey);
                        for (let child1 of sourceTable.getChildren()) {
                            let sourceField = <TagNode>child1;
                            if(sourceField.hasAttribute(CommonConstant.NODE_Definition)){
                                sourceField.getParent()!.removeChild(sourceField);
                            }else{
                                sourceField.removeAttribute(CommonConstant.NODE_TargetTableKey);
                                sourceField.removeAttribute(CommonConstant.NODE_TargetFieldKey);
                            }
                        }
                    }else {
                        for (let child1 of sourceTable.getChildren()) {
                            let sourceField = <TagNode>child1;
                            if (sourceField.getAttributeValue(CommonConstant.NODE_TargetTableKey) == tableKey) {
                                if(sourceField.hasAttribute(CommonConstant.NODE_Definition)){
                                    sourceField.getParent()!.removeChild(sourceField);
                                }else{
                                    sourceField.removeAttribute(CommonConstant.NODE_TargetTableKey);
                                    sourceField.removeAttribute(CommonConstant.NODE_TargetFieldKey);
                                }
                            }
                        }
                    }
                }

            }else if(selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_FeedbackTable){
                let tableKey = selectFieldViewTagNode?.getAttributeValue(CommonConstant.ATTR_TableKey);
                this.tableKey = tableKey;
                let targetTableCollection = root.find(CommonConstant.NODE_TargetTableCollection, "", "")!;
                let formKey = selectFieldViewTagNode.getParent()!.getAttributeValue(CommonConstant.ATTR_FormKey);
                for (let child of targetTableCollection.getChildren()) {
                    let targetTable = <TagNode>child;
                    for (let child1 of targetTable.getChildren()) {
                        let targetField = <TagNode>child1;
                        let feedBacks = targetField.getChildren();
                        if (feedBacks.length == 0) continue;
                        for (let f of feedBacks) {
                            let feedBack = <TagNode>f;
                            if (feedBack.getAttributeValue(CommonConstant.NODE_FeedFormKey) == formKey
                                && feedBack.getAttributeValue(CommonConstant.ATTR_TableKey) == tableKey) {
                                targetField.removeChild(feedBack);
                            }
                        }
                    }
                }
            }else{
                let tableKey = selectFieldViewTagNode?.getAttributeValue(CommonConstant.S_Key);
                this.tableKey = tableKey;
            }
            parent?.removeChild(selectFieldViewTagNode!);
        }else {
            // 删除字段之前需要把源表中引用的 target 和 feedback 信息删除
            if (selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_TargetField) {
                let definition = selectFieldViewTagNode.getAttributeValue(CommonConstant.NODE_Definition);
                let tableKey = parent!.getAttributeValue(CommonConstant.S_Key);
                let sourceTableCollection = root.find(CommonConstant.NODE_SourceTableCollection, "", "")!;
                for (let child of sourceTableCollection.getChildren()) {
                    let sourceTable = <TagNode>child;
                    for (let child1 of sourceTable.getChildren()) {
                        let sourceField = <TagNode>child1;
                        if (sourceField.getAttributeValue(CommonConstant.NODE_TargetTableKey) == tableKey
                            && sourceField.getAttributeValue(CommonConstant.NODE_TargetFieldKey) == definition) {
                            if(sourceField.hasAttribute(CommonConstant.NODE_Definition)){
                                sourceField.getParent()!.removeChild(sourceField);
                            }else{
                                sourceField.removeAttribute(CommonConstant.NODE_TargetTableKey);
                                sourceField.removeAttribute(CommonConstant.NODE_TargetFieldKey);
                            }
                        }
                    }
                }
            } else if ((selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_FeedbackField)) {
                let fieldKey = selectFieldViewTagNode.getAttributeValue(CommonConstant.NODE_FieldKey);
                let tableKey = parent!.getAttributeValue(CommonConstant.ATTR_TableKey);
                let feedBackObject = parent!.getParent()!;
                let formKey = feedBackObject.getAttributeValue(CommonConstant.ATTR_FormKey);
                let targetTableCollection = root.find(CommonConstant.NODE_TargetTableCollection, "", "")!;

                for (let child of targetTableCollection.getChildren()) {
                    let targetTable = <TagNode>child;
                    let tagNodeList = new ArrayList<ITagNode>();
                    for (let child1 of targetTable.getChildren()) {
                        let targetField = <TagNode>child1;
                        let feedBacks = targetField.getChildren();
                        let tagNodeXml = targetField.toXml(true);
                        let tagNode = XmlEntity.parseTagNode(tagNodeXml);
                        tagNodeList.add(tagNode);
                        if (feedBacks.length == 0) continue;
                        for (let f of feedBacks) {
                            let feedBack = <TagNode>f;
                            if (feedBack.getAttributeValue(CommonConstant.NODE_FeedFormKey) == formKey
                                && feedBack.getAttributeValue(CommonConstant.ATTR_TableKey) == tableKey
                                && feedBack.getAttributeValue(CommonConstant.ATTR_FieldKey) == fieldKey) {
                                targetField.removeChild(feedBack);
                            }
                        }
                    }
                }
            }

            let attr = CommonConstant.NODE_Definition;
            if(parent.getTagName() == CommonConstant.NODE_SourceTable){
                attr = CommonConstant.S_Key;
            }
            if(selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_SourceTable){
                parent?.removeChild(selectFieldViewTagNode);
            }
            // 如果删除的table里只剩一个field了 直接把表删除
            else if (parent?.getChildren().length == 1 &&
                (selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_SourceField || selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_TargetField
                    || selectFieldViewTagNode?.getTagName() == CommonConstant.NODE_FeedbackField)) {
                let parent1 = parent.getParent();
                parent1?.removeChild(parent.getTagNode());
            } else {
                for (let i = parent!.getChildren().length -1; i >= 0; i--) {
                    let field = <ITagNode>parent!.getChildren()[i];

                    if (selectFieldViewTagNode.getTagName() == CommonConstant.NODE_SourceField) {
                        if (selectFieldViewTagNode.hasAttribute(CommonConstant.NODE_Definition)) {
                            if (selectFieldViewTagNode.getAttributeValue(CommonConstant.NODE_Definition) == field.getAttributeValue(CommonConstant.NODE_Definition)
                                || selectFieldViewTagNode.getAttributeValue(CommonConstant.NODE_Definition) == field.getAttributeValue(CommonConstant.S_Key)) {
                                parent?.removeChild(field);
                            }
                        } else {
                            if (selectFieldViewTagNode.getAttributeValue(CommonConstant.S_Key) == field.getAttributeValue(CommonConstant.S_Key)
                                || selectFieldViewTagNode.getAttributeValue(CommonConstant.S_Key) == field.getAttributeValue(CommonConstant.NODE_Definition)) {
                                parent?.removeChild(field);
                            }
                        }
                        if (!parent?.getChildren() || parent?.getChildren().length < 1) {
                            let parent1 = parent!.getParent();
                            parent1?.removeChild(parent!.getTagNode());
                        }
                    } else if (selectFieldViewTagNode.getTagName() == CommonConstant.NODE_TargetField) {
                        if (field.getAttributeValue(CommonConstant.NODE_Definition) == selectFieldViewTagNode?.getAttributeValue(CommonConstant.NODE_Definition)) {
                            parent?.removeChild(field);
                        }
                    } else if (selectFieldViewTagNode.getTagName() == CommonConstant.NODE_FeedbackField) {
                        if (field.getAttributeValue(CommonConstant.NODE_FieldKey) == selectFieldViewTagNode?.getAttributeValue(CommonConstant.NODE_FieldKey)) {
                            parent?.removeChild(field);
                        }
                    }

                }
            }
        }
        this.dataMapGraphicView.getXmlEntity().update(root,false);
        return true;
    }

    undo(): void {
        let root = this.dataMapGraphicView.getXmlEntity().getTagRoot();
        if(this.oldXmlEntity) {
            root.clearChildren();
            let parent = XmlEntity.parseTagNode(this.selectNodeParentXml!);
            let mapChilds = this.oldXmlEntity.getChildren();

            if (parent.getTagName() == CommonConstant.NODE_SourceTableCollection || parent.getTagName() == CommonConstant.NODE_TargetTableCollection
                || parent.getTagName() == CommonConstant.NODE_FeedbackObject) {
                for (let i = 0; i < mapChilds.length; i++) {
                    let mapChild = <ITagNode>mapChilds[i];
                    for (let j = 0; j < mapChild.getChildren().length; j++) {
                        let table = <ITagNode>mapChild.getChildren()[j];
                        if(mapChild.getTagName() != parent.getTagName() || this.tableKey != table.getAttributeValue(CommonConstant.S_Key)) continue;
                        this.selectNode = table;
                    }
                    root.addChild(mapChild);
                }

            } else {
                //删除时，会从父节点移除节点，重做时导致this.dataMapGraphicView.getSelectFieldTagNode()获取到的对象结构发生变化，不得不用以下这种方式重新构建
                for (let i = 0; i < mapChilds.length; i++) {
                    let mapChild = <ITagNode>mapChilds[i];
                    for (let j = 0; j < mapChild.getChildren().length; j++) {
                    if(mapChild.getTagName() != CommonConstant.NODE_SourceTableCollection && mapChild.getTagName() != CommonConstant.NODE_TargetTableCollection
                    && mapChild.getTagName() != CommonConstant.NODE_FeedbackCollection) continue;
                        let table = <ITagNode>mapChild.getChildren()[j];
                        //反填表单选中情况较为复杂，暂不考虑，重做功能失效
                        if (table.getTagName() != parent.getTagName()) continue;
                        for (let k = 0; k < table.getChildren().length; k++) {
                            let field = <ITagNode>table.getChildren()[k];
                            let definition;
                            if (table.getTagName() == CommonConstant.NODE_SourceTable) {
                                definition = CommonConstant.S_Key;
                            } else if (table.getTagName() == CommonConstant.NODE_TargetTable) {
                                definition = CommonConstant.NODE_Definition;
                            } else {
                                definition = CommonConstant.NODE_FieldKey;
                            }
                            if (field.getAttributeValue(definition) == this.selectNode!.getAttributeValue(definition)) {
                                this.selectNode = field;
                                break;
                            }
                        }
                    }
                    root.addChild(mapChild);
                }
            }
            this.dataMapGraphicView.getXmlEntity().update(root,false);
            this.dataMapGraphicView.setSelectFieldTagNode(this.selectNode!);
        }
    }


}