import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";

export class DataMapMoveFieldCmd implements ICmd{
    private xmlEntity: IXmlEntity;
    private fromNode: ITagNode;
    private toNode: ITagNode;

    constructor(xmlEntity: IXmlEntity, fromNode: ITagNode, toNode: ITagNode){
        this.xmlEntity = xmlEntity;
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    do(): boolean {
        let parent = this.fromNode.getParent();
        let children = parent!.getChildren();
        let fromIndex = children.indexOf(this.fromNode);
        let toIndex = children.indexOf(this.toNode);
        [children[fromIndex], children[toIndex]] = [children[toIndex], children[fromIndex]];
        this.xmlEntity.update(parent,false);
        return true;
    }

    undo(): void {
        let parent = this.fromNode.getParent()!;
        let children = parent.getChildren();
        let formNodeIndex = children.indexOf(this.fromNode);
        let tarNodeIndex = children.indexOf(this.toNode);
        [children[formNodeIndex], children[tarNodeIndex]] = [children[tarNodeIndex], children[formNodeIndex]];
        this.xmlEntity.update(parent, false);
    }

}