import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import {CommonConstant} from "../base/CommonConstant";
import IXmlEntity from "../../../common/xml/IXmlEntity";

export class AddSourceFieldCmd implements ICmd {
    private dataMapGraphicView: DataMapGraphicView;
    private tableKey: string;
    private newField: string;
    private tagNode: ITagNode;
    private newTagNode?: ITagNode;

    constructor(dataMapGraphicView: DataMapGraphicView, tableKey: string, fieldKey: string, tagNode: ITagNode){
        this.dataMapGraphicView = dataMapGraphicView;
        this.tableKey = tableKey;
        this.newField = fieldKey;
        this.tagNode = tagNode;
    }

    do(): boolean {
        let tagNode = this.tagNode;
        let xmlEntity = this.dataMapGraphicView.getXmlEntity();
        if(tagNode.getTagName() == CommonConstant.NODE_SourceTableCollection){
            let sourceTable = <ITagNode>tagNode.find(CommonConstant.NODE_SourceTable, CommonConstant.NODE_Table_Key, this.tableKey);
            if(sourceTable){
                this.addSourceField(sourceTable,xmlEntity);
            }else{
                let newTableTagNode = xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_SourceTable);
                newTableTagNode.setAttributeValue(CommonConstant.NODE_Table_Key, this.tableKey);
                newTableTagNode.setAttributeValue(CommonConstant.ATTR_Type, "Table");
                newTableTagNode.setAttributeValue(CommonConstant.ATTR_DataSource,this.tableKey);
                this.addSourceField(newTableTagNode, xmlEntity);
                tagNode.addChild(newTableTagNode);
                this.newTagNode = newTableTagNode;
            }
        }else{
            this.addSourceField(tagNode, xmlEntity);
        }
        xmlEntity.update(tagNode,true);
        return true;
    }

    addSourceField(tagNode: ITagNode, xmlEntity: IXmlEntity) {
        if (tagNode.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, this.newField)) return true;
        let newTagNode = xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_SourceField);
        newTagNode.setAttributeValue(CommonConstant.S_Key, this.newField);
        tagNode.addChild(newTagNode);
        this.newTagNode = newTagNode;
    }

    undo(): void {
        if (this.newTagNode) {
            this.dataMapGraphicView.getXmlEntity().removeNode(this.newTagNode);
        }
    }

}