import ICmd from "../../../common/cmd/ICmd";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import {CommonConstant} from "../base/CommonConstant";
import {CommonFunction} from "../base/CommonFunction";

export class AddLinkCmd implements ICmd {
    private xmlEntity: IXmlEntity;
    private fromNode: ITagNode;
    private toNode: ITagNode;
    private newNode?: ITagNode;
    private parentFromNode?: ITagNode;

    constructor(xmlEntity: IXmlEntity, fromNode: ITagNode, toNode: ITagNode) {
        this.xmlEntity = xmlEntity;
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    do(): boolean {
        if (this.fromNode.getTagName() == CommonConstant.NODE_SourceField && this.toNode.getTagName() == CommonConstant.NODE_TargetField) {
            this.addLinkStcToTtc();
        } else if (this.fromNode.getTagName() == CommonConstant.NODE_TargetField && this.toNode.getTagName() == CommonConstant.NODE_FeedbackField) {
            this.addLinkTtcToFeedback();
        }
        return true;
    }

    addLinkStcToTtc() {
        let toNode = this.toNode;
        let tarDefinition = toNode.getAttributeValue(CommonConstant.NODE_Definition);
        let tarTableKey = toNode.getParent()!.getAttributeValue(CommonConstant.NODE_Table_Key);
        let fromNode = this.fromNode;

        if (!fromNode.getAttributeValue(CommonConstant.NODE_TargetFieldKey)) {
            this.updateSourceFieldValue(fromNode, tarTableKey, tarDefinition, toNode);
        } else if (fromNode.getAttributeValue(CommonConstant.NODE_TargetFieldKey) == tarDefinition
            && fromNode.getAttributeValue(CommonConstant.NODE_TargetTableKey) == tarTableKey) {
            return;
        } else {
            this.addSourceFieldValue(fromNode, tarTableKey, tarDefinition, toNode);
        }


    }

    addLinkTtcToFeedback() {
        let fromNode = this.fromNode;
        let childrens = fromNode.getChildren();
        let newTagDataObject = this.toNode.getParent()!.getParent()!.getAttributeValue(CommonConstant.NODE_FeedbackObjectKey);
        let newTagFormKey = this.toNode.getParent()!.getParent()!.getAttributeValue(CommonConstant.NODE_FormKey);
        let newTagTableKey = this.toNode.getParent()!.getAttributeValue(CommonConstant.NODE_FeedbackTableKey);
        let newTagFieldKey = this.toNode.getAttributeValue(CommonConstant.NODE_FieldKey);

        if (childrens.length > 0) {
            for (let i = 0; i < childrens.length; i++) {
                let child = <ITagNode>childrens[i];
                if (child.getAttributeValue(CommonConstant.NODE_FeedbackDataObjectKey) == newTagDataObject
                    && child.getAttributeValue(CommonConstant.NODE_FeedFormKey) == newTagFormKey
                    && child.getAttributeValue(CommonConstant.NODE_FeedbackTableKey) == newTagTableKey
                    && child.getAttributeValue(CommonConstant.NODE_FieldKey) == newTagFieldKey) {
                    return;
                }
            }
            this.addFeedback(fromNode, newTagDataObject, newTagFormKey, newTagTableKey, newTagFieldKey);
        } else {
            this.addFeedback(fromNode, newTagDataObject, newTagFormKey, newTagTableKey, newTagFieldKey);
        }
    }

    //判断反填表单字段是否已经被其它字段连线
    checkIsUse(fromNode: ITagNode, newTagDataObject: string, newTagFormKey: string, newTagTableKey: string, newTagFieldKey: string): boolean {
        let targetForm = fromNode.getParent()!.getParent()!;
        let targetTables = targetForm.getChildren();
        if (targetTables.length < 1) return false;
        for (let i = 0; i < targetTables.length; i++) {
            let targetTable = <ITagNode>targetTables[i];
            let targetFields = targetTable.getChildren();
            if (targetFields.length > 0) {
                for (let j = 0; j < targetFields.length; j++) {
                    let targetField = <ITagNode>targetFields[j];
                    let feedbacks = targetField.getChildren();
                    if (feedbacks.length > 0) {
                        for (let k = 0; k < feedbacks.length; k++) {
                            let feedback = <ITagNode>feedbacks[k];
                            if (feedback.getAttributeValue(CommonConstant.NODE_FeedbackDataObjectKey) == newTagDataObject
                                && feedback.getAttributeValue(CommonConstant.NODE_FeedFormKey) == newTagFormKey
                                && feedback.getAttributeValue(CommonConstant.NODE_FeedbackTableKey) == newTagTableKey
                                && feedback.getAttributeValue(CommonConstant.NODE_FieldKey) == newTagFieldKey) {
                                return true;
                            }
                        }
                    }
                }

            }
        }
        return false;
    }

    addFeedback(fromNode: ITagNode, newTagDataObject: string, newTagFormKey: string, newTagTableKey: string, newTagFieldKey: string) {
        this.parentFromNode = fromNode;
        let newNode = this.xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_FEEDBACK);
        newNode.setAttributeValue(CommonConstant.NODE_FeedbackDataObjectKey, newTagDataObject);
        newNode.setAttributeValue(CommonConstant.NODE_FeedFormKey, newTagFormKey);
        newNode.setAttributeValue(CommonConstant.NODE_FeedbackTableKey, newTagTableKey);
        newNode.setAttributeValue(CommonConstant.NODE_FieldKey, newTagFieldKey);
        this.newNode = newNode;
        fromNode.addChild(newNode);
        this.xmlEntity.update(fromNode, true);
    }

    addSourceFieldValue(scrNode: ITagNode, tarTableKey: string, tarDefinition: string, tagNode: ITagNode) {
        let parentNode = scrNode.getParent()!;
        let newFieldNode = this.xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_SourceField);
        let srcNodeType = scrNode.getAttributeValue(CommonConstant.NODE_Type, "");

        let tagNodeType = tagNode.getAttributeValue(CommonConstant.NODE_Type, "");
        if (tagNodeType == "") {
            let find = parentNode.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, tarDefinition);
            if (find == null) {
                newFieldNode.setAttributeValue(CommonConstant.S_Key, tarDefinition);
            } else {
                let i = 1;
                while (tagNode.find(CommonConstant.NODE_SourceField, CommonConstant.NODE_Definition, tarDefinition + i) != null) {
                    i++;
                }
                newFieldNode.setAttributeValue(CommonConstant.S_Key, tarDefinition + i);
            }
            if (srcNodeType != "") {
                newFieldNode.setAttributeValue(CommonConstant.NODE_Type, srcNodeType);
            }
        } else {
            if (srcNodeType == "") {
                let key = CommonFunction.getSourceFieldKey(this.fromNode);
                newFieldNode.setAttributeValue(CommonConstant.S_Key, key);
            } else {
                let find = parentNode.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, srcNodeType);
                if (find == null) {
                    newFieldNode.setAttributeValue(CommonConstant.S_Key, srcNodeType);
                } else {
                    let i = 1;
                    while (tagNode.find(CommonConstant.NODE_SourceField, CommonConstant.NODE_Definition, srcNodeType + i) != null) {
                        i++;
                    }
                    newFieldNode.setAttributeValue(CommonConstant.S_Key, srcNodeType + i);
                }
                newFieldNode.setAttributeValue(CommonConstant.NODE_Type, srcNodeType);
            }
        }
        let definition = this.fromNode.getAttributeValue(CommonConstant.NODE_Definition, "");
        if (definition == "") {
            definition = this.fromNode.getAttributeValue(CommonConstant.S_Key);
        }
        newFieldNode.setAttributeValue(CommonConstant.NODE_Definition, definition);
        newFieldNode.setAttributeValue(CommonConstant.NODE_TargetTableKey, tarTableKey);
        newFieldNode.setAttributeValue(CommonConstant.NODE_TargetFieldKey, tarDefinition);

        parentNode.addChild(newFieldNode);
        this.parentFromNode = parentNode;
        this.newNode = newFieldNode;
        this.xmlEntity.update(parentNode, true);

    }

    updateSourceFieldValue(scrNode: ITagNode, tarTableKey: string, tarDefinition: string, tagNode: ITagNode) {
        scrNode.setAttributeValue(CommonConstant.NODE_TargetTableKey, tarTableKey);
        scrNode.setAttributeValue(CommonConstant.NODE_TargetFieldKey, tarDefinition);
        let type = scrNode.getAttributeValue(CommonConstant.NODE_Type, "");
        if (type != "") {
            let tagNodeType = tagNode.getAttributeValue(CommonConstant.NODE_Type, "");
            if (tagNodeType == "") {
                let parent = scrNode.getParent();
                if (parent!.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, tarDefinition) != null) {
                    let i = 1;
                    while (parent!.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, tarDefinition + i) != null) {
                        i++;
                    }
                    scrNode.setAttributeValue(CommonConstant.S_Key, tarDefinition + i);
                } else {
                    scrNode.setAttributeValue(CommonConstant.S_Key, tarDefinition);
                }
            }
        }
        this.newNode = scrNode;
        this.xmlEntity.update(this.newNode, true);
    }

    undo(): void {
        if (this.fromNode.getTagName() == CommonConstant.NODE_SourceField && this.toNode.getTagName() == CommonConstant.NODE_TargetField) {
            this.removeLinkStcToTtc();
        } else if (this.fromNode.getTagName() == CommonConstant.NODE_TargetField && this.toNode.getTagName() == CommonConstant.NODE_FeedbackField) {
            this.removeLinkTtcToFeedback();
        }
    }

    removeLinkStcToTtc() {
        if (!this.newNode) return;
        if (this.parentFromNode) {
            this.parentFromNode.removeChild(this.newNode);
            this.xmlEntity.update(this.parentFromNode, true);
        } else {
            this.newNode.removeAttribute(CommonConstant.NODE_TargetTableKey);
            this.newNode.removeAttribute(CommonConstant.NODE_TargetFieldKey);
            this.newNode.removeAttribute(CommonConstant.NODE_OpSign);
            this.xmlEntity.update(this.newNode, true);
        }
    }

    removeLinkTtcToFeedback() {
        if (!this.newNode) return;
        if (this.parentFromNode) {
            this.parentFromNode.removeChild(this.newNode);
            this.xmlEntity.update(this.parentFromNode, true);
        }
    }

}