import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import {CommonConstant} from "../base/CommonConstant";
import IXmlEntity from "../../../common/xml/IXmlEntity";

export class AddFeedBackFieldCmd implements ICmd {
    private dataMapGraphicView: DataMapGraphicView;
    private tableKey: string;
    private newField: string;
    private tagNode: ITagNode;
    private newTagNode?: ITagNode;

    constructor(dataMapGraphicView: DataMapGraphicView, tableKey: string, fieldKey: string, tagNode: ITagNode){
        this.dataMapGraphicView = dataMapGraphicView;
        this.tableKey = tableKey;
        this.newField = fieldKey;
        this.tagNode = tagNode;
    }

    do(): boolean {
        let tagNode = this.tagNode;
        let xmlEntity = this.dataMapGraphicView.getXmlEntity();
        if(tagNode.getTagName() == CommonConstant.NODE_FeedbackObject){
            let feedBackTable = <ITagNode>tagNode.find(CommonConstant.NODE_FeedbackTable, CommonConstant.ATTR_TableKey, this.tableKey);
            if(feedBackTable){
                this.addField(feedBackTable,xmlEntity);
            }else{
                let newTableTagNode = xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_FeedbackTable);
                newTableTagNode.setAttributeValue(CommonConstant.NODE_FeedbackTableKey, this.tableKey);
                tagNode.addChild(newTableTagNode);
                this.addField(newTableTagNode, xmlEntity);
            }
        }else{
            this.addField(tagNode, xmlEntity);
        }
        xmlEntity.update(tagNode,true);
        return true;
    }

    addField(tagNode: ITagNode, xmlEntity: IXmlEntity){
        if(tagNode.find(CommonConstant.NODE_FeedbackField, CommonConstant.ATTR_FieldKey, this.newField)) return true;
        let newTagNode = xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_FeedbackField);
        newTagNode.setAttributeValue(CommonConstant.ATTR_FieldKey, this.newField);
        tagNode.addChild(newTagNode);
        this.newTagNode = newTagNode;
    }

    undo(): void {
        if (this.newTagNode) {
            this.dataMapGraphicView.getXmlEntity().removeNode(this.newTagNode);
        }
    }

}