import ITagNode from "../../../common/xml/node/ITagNode";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import BaseConstants from "../../base/BaseConstants";
import {CommonConstant} from "./CommonConstant";
import DomUtil from "../../../common/dom/DomUtil";
import {FieldRow} from "../view/element/FieldRow";
import {DataMapTableLayout} from "../layout/DataMapTableLayout";
import ArrayList from "../../../common/struct/ArrayList";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import TagNode from "../../../common/xml/node/TagNode";

export class CommonFunction {

    static GetAllFields(root: ITagNode, operationDispatcher: OperationDispatcher, graphicView: DataMapGraphicView, xmlEntity: IXmlEntity, path: string) {
        let srcFormula = "Macro_getDataMapFields()";
        operationDispatcher.eval(srcFormula).then((res) => {
            let parse = JSON.parse(res);
            let srcMap = new Map<string, any>();
            let tarMap = new Map<string, any>();
            let feedbackMapList = new ArrayList<Map<string, any>>();
            for (let parseKey in parse["srcitems"]) {
                srcMap.set(parseKey, parse["srcitems"][parseKey]);
            }
            for (let parseKey in parse["taritems"]) {
                tarMap.set(parseKey, parse["taritems"][parseKey]);
            }
            let parseElement = parse["feedbackItems"];
            for (let i = 0; i < parseElement.length; i++) {
                let feedbackMap = new Map<string, any>();
                for (let parseKey in parseElement[i]) {
                    feedbackMap.set(parseKey, parseElement[i][parseKey]);
                }
                feedbackMapList.add(feedbackMap);
            }graphicView.setSrcMap(srcMap);
            graphicView.setTarMap(tarMap);
            graphicView.setSrcFormKey(parse.SrcFormKey);
            graphicView.setTgtFormKey(parse.TgtFormKey);
            graphicView.setSrcDataObjectKey(parse.SrcDataObjectKey);
            graphicView.setTgtDataObjectKey(parse.TgtDataObjectKey);
            graphicView.setFeedBackMapList(feedbackMapList);
            graphicView.loadView(xmlEntity, operationDispatcher, path);
        });
    }

    static reloadTableCollectionHeight(xmlEntity: IXmlEntity): void {//自动计算表集合的高度
        let tagMigration = xmlEntity.getTagRoot();
        let nodes = tagMigration.getChildren();

        for (let i = 0; i < nodes.length ; i++) {
            let tagName = (<ITagNode>nodes[i]).getTagName();
            if (tagName == CommonConstant.NODE_SourceTableCollection) {
                this.reloadTableHeight(<ITagNode>nodes[i]);
                continue
            }
            if (tagName == CommonConstant.NODE_TargetTableCollection) {
                this.reloadTableHeight(<ITagNode>nodes[i]);
                continue
            }
            if (tagName == CommonConstant.NODE_FeedbackCollection) {
                let nodeFeedbackList = (<ITagNode>nodes[i]).getChildren();
                for (let i = 0; i < nodeFeedbackList.length; i++) {
                    this.reloadTableHeight(<ITagNode>nodeFeedbackList[i]);
                }
            }
        }
    }

    static reloadTableHeight(node: ITagNode): void {
        let rowSize = 2;
        let children = node.getChildren();
        rowSize = rowSize + children.length * 2;
        for (let child of children) {
            let table = <ITagNode>child;
            let length = table.getChildren().length;
            rowSize = rowSize + length;
        }
        let attributeValue = node.getAttributeValue(CommonConstant.ATTR_Height, "0");
        if (Number(attributeValue) < rowSize * CommonConstant.ROW_HEIGHT) {
            node.setAttributeValue(CommonConstant.ATTR_Height, (rowSize * CommonConstant.ROW_HEIGHT).toString());
        }
    }

    static checkDesignViewHeight(xmlEntity: IXmlEntity): number {
        let tagMigration = xmlEntity.getTagRoot();
        var nodes = tagMigration.getChildren();
        let sorHeight = 0; let sorY = 0; let tarHeight = 0; let tarY = 0; let maxTgtHeight = 0;
        for (let i = 0; i < nodes.length ; i++) {
            let tagNode = <ITagNode>nodes[i];
            let tagName = tagNode.getTagName();
            if (tagName == CommonConstant.NODE_SourceTableCollection) {
                sorHeight = tagNode.getAttributeValueInt(BaseConstants.ATTR_Height, 0);
                sorY = tagNode.getAttributeValueInt(BaseConstants.ATTR_Y, 0);
                continue
            }
            if (tagName == CommonConstant.NODE_TargetTableCollection) {
                tarHeight = tagNode.getAttributeValueInt(BaseConstants.ATTR_Height, 0);
                tarY = tagNode.getAttributeValueInt(BaseConstants.ATTR_Y, 0);
                continue
            }
            if (tagName == CommonConstant.NODE_FeedbackCollection) {
                let nodeFeedbackList = tagNode.getChildren();
                for (let i = 0; i < nodeFeedbackList.length; i++) {
                    let feedbackNode = <ITagNode>nodeFeedbackList[i];
                    let feedbackHeight = feedbackNode.getAttributeValueInt(BaseConstants.ATTR_Height, 0);
                    let feedbackY = feedbackNode.getAttributeValueInt(BaseConstants.ATTR_Y, 0);
                    maxTgtHeight = feedbackHeight + feedbackY ;
                }
            }
        }
        let maxHeight = sorHeight + sorY > tarHeight + tarY ? sorHeight + sorY : tarHeight + tarY;
        if(maxTgtHeight){
            maxHeight = maxHeight > maxTgtHeight ? maxHeight : maxTgtHeight;
        }
        return maxHeight;

    }

    static containPoint(x: number, y: number, element: HTMLElement): boolean {
        let offsetParent = DomUtil.offsetParent(element);
        let top = offsetParent.offsetTop;
        let left = offsetParent.offsetLeft;
        let width = element.clientWidth;
        let height = element.clientHeight;
        return x >= left && x <= (left + width) && y >= top && y <= (top + height);
    }

    static locRow(x: number, y: number, tableLayout: DataMapTableLayout): FieldRow | null {
        let rowLocation = tableLayout.hitRow(x, y);
        if (rowLocation) {
            let row = tableLayout.getRow(rowLocation);
            return <FieldRow>row.getContent();
        } else if (rowLocation == 0) {
            let row = tableLayout.getRow(0);
            return <FieldRow>row.getContent();
        }
        return null;

    }

    static getSelectTarget(e: MouseEvent): HTMLElement {
        let target = <HTMLElement>e.target;
        if (target.nodeName == CommonConstant.Node_Type_Span || target.nodeName == CommonConstant.Node_Type_Td) {
            //往上递归，找到TR
            while (target.nodeName != "TR") {
                if (target.parentElement) {
                    target = target.parentElement;
                } else {
                    break;
                }
            }
        }
        return target;
    }

    static setTableMaxKey(tableNode: ITagNode) {
        let children = tableNode.getChildren();
        let maxKey = -1;
        for (let child of children) {
            let key = (<TagNode>child).getAttributeValue(CommonConstant.S_Key).match(/\d+/);
            if (!key) continue;
            let numStr = Number.parseInt(key[key.length - 1]);
            maxKey = maxKey > numStr ? maxKey : numStr;
        }
        tableNode.setAttributeValue(CommonConstant.NODE_MaxKey, maxKey.toString());
    }

    static hasField(tagNode: ITagNode, value: string, xmlEntity: IXmlEntity){
        let attr  = CommonConstant.S_Key;
        if(tagNode.getAttributeValue(attr) == value) return false;
        let parent= tagNode.getParent();
        if(!parent) return false;
        let grandfather = parent.getParent();
        let child = xmlEntity.getTagRoot().getChildren();
        for (let i = 0; i < child.length; i++){
            let tableColllection = <ITagNode>child[i];
            if(tableColllection.getTagName() == grandfather!.getTagName()){
                let table = tableColllection.find(parent.getTagName(),CommonConstant.S_Key,parent.getAttributeValue(CommonConstant.S_Key));
                if(!table) return false;
                let fields = table.getChildren();
                for (let j = 0; j < fields.length; j++){
                    let field = <ITagNode>fields[j];
                    if (xmlEntity.getSelectionModel().getSingleSeletionItem() == field) continue;
                    if(field.getAttributeValue(attr) == value){
                        // @ts-ignore
                        layui.layer.msg("同表单内请不要定义重复字段", {icon: 5, time: 5000,})
                        return true;
                    }
                    const hasTypeAttr = tagNode.hasAttribute(CommonConstant.ATTR_Type);
                    if (hasTypeAttr) {
                        if (field.getAttributeValue("Definition") == value) {
                            // @ts-ignore
                            layui.layer.msg("同表单内请不要定义重复字段", {icon: 5, time: 5000,})
                            return true;
                        }
                    }
                }
            }
        }
        return false;

    }

    static getVestSourceFieldKey(tagNode: ITagNode): string{
        let sourceTable = tagNode.getParent();
        let sourceFields = sourceTable!.getChildren();
        let count = 0;
        for (let i = 0; i < sourceFields.length; i++){
            let sourceField = <ITagNode>sourceFields[i];
            if(sourceField.getAttributeValue(CommonConstant.NODE_Definition) == tagNode.getAttributeValue(CommonConstant.NODE_Definition)){
                count ++ ;
                //存在key相同的情况，再 ++
                if(sourceField.getAttributeValue(CommonConstant.S_Key) ==  tagNode.getAttributeValue(CommonConstant.NODE_Definition) + count){
                    count ++ ;
                }
            }
        }
        return  tagNode.getAttributeValue(CommonConstant.NODE_Definition) + count;
    }

    static getSourceFieldKey(tagNode: ITagNode): string{
        let sourceTable = tagNode.getParent();
        let sourceFields = sourceTable!.getChildren();
        let count = 1;
        for (let i = 0; i < sourceFields.length; i++){
            let sourceField = <ITagNode>sourceFields[i];
            if(sourceField.getAttributeValue(CommonConstant.NODE_Definition) == tagNode.getAttributeValue(CommonConstant.S_Key)){
                count ++ ;
                //存在key相同的情况，再 ++
                if(sourceField.getAttributeValue(CommonConstant.S_Key) == tagNode.getAttributeValue(CommonConstant.S_Key)+ count){
                    count ++ ;
                }
            }
        }
        return tagNode.getAttributeValue(CommonConstant.S_Key) + count;
    }

    static getSourceFieldValue(tagNode: ITagNode): string{
        let fieldKey;
        if(tagNode.hasAttribute(CommonConstant.NODE_Definition)){
            fieldKey = tagNode.getAttributeValue(CommonConstant.NODE_Definition);
        }else {
            fieldKey = tagNode.getAttributeValue(CommonConstant.S_Key);
        }
        return fieldKey;
    }

}