import IGElement from "../../../common/ui/graphic/IGElement";
import IGTable from "../../../common/ui/graphic/IGTable";
import ITagNode from "../../../common/xml/node/ITagNode";
import TagNode from "../../../common/xml/node/TagNode";
import I18N from "../../bpm/base/I18N";
import {CommonConstant} from "./CommonConstant";

export abstract class AbstractElement {
    protected dblClickHandler?: (event: MouseEvent) => void;
    private gCaptionElement?: IGElement;
    protected gSection!: IGTable;
    protected xmlNode: ITagNode;

    constructor(xmlNode?: ITagNode) {
        this.xmlNode = xmlNode ? xmlNode : new TagNode(this.getType());
        if(!this.getCaption()) {
            this.setCaption(this.getDefaultCaption());
        }
    }

    initGSection(section: IGTable): void {
        this.gSection = section;
        this.drawGraphic(section);
        this.update();

    }

    private update(): void {
        //         // 绘制文本
        this.updataView();
    }

    updataView(): void {
        this.setLocation(this.getX(), this.getY());
        this.updateCaption(this.getCaption());
        this.xmlNode.isSelected() ? this.markSelected() : this.markUnSelected();
    }

    getX(): number {
        return this.ensureGraphicTagNode().getAttributeValueInt(CommonConstant.ATTR_X, 0);
    }

    getY(): number {
        return this.ensureGraphicTagNode().getAttributeValueInt(CommonConstant.ATTR_Y, 0);
    }

    setLocation(x: number, y: number) {
        this.ensureGraphicTagNode().setAttributeValue(CommonConstant.ATTR_X, String(x));
        this.ensureGraphicTagNode().setAttributeValue(CommonConstant.ATTR_Y, String(y));
    }

    setCaption(caption: string): void {
        this.xmlNode.setAttributeValue(CommonConstant.S_Caption, caption);
    }

    updateCaption(caption: string) {
        if (this.gCaptionElement) {
            this.gCaptionElement.getHtmlElement().innerHTML = caption;
        }
    }

    getGCaption(): IGElement | undefined {
        return this.gCaptionElement;
    }

    getCaption(): string {
        return this.xmlNode.getAttributeValue(CommonConstant.S_Caption);
    }

    protected getDefaultCaption(): string {
        return I18N.getString(this.getType());
    }

    isSelected(): boolean {
        return this.xmlNode.isSelected();
    }

    getTagNode() {
        return this.xmlNode;
    }


    remove(): void {
        this.gSection.remove();
    }

    abstract drawGraphic(gSection: IGTable): IGTable;
    abstract markSelected(): void;
    abstract getType(): string;
    abstract markUnSelected(): void;
    abstract ensureGraphicTagNode(): ITagNode;
}