import ITagNode from "../../../../../../common/xml/node/ITagNode";
import WfConstants from "../../../../base/WfConstants";
import AbstractWfElement from "../../AbstractWfElement";
import BaseDiamondNode from "./BaseDiamondNode";

export default class ForkNode extends BaseDiamondNode {

    constructor(xmlNode?: ITagNode) {
        super(xmlNode);
    }

    protected drawSymbo(): void{
        var pathAttr = {stroke: "#000", strokeWidth: 1};
        var w = this.getBounds().width,
            h = this.getBounds().height;
        this.gSection.path( "M" + (w/2 - 15) + " " + (h/2) + "L" +(w/2 + 15) + " " + (h/2)).attr(pathAttr);
        this.gSection.path( "M" + (w/2 + 5) + " " + (h/2 + 10) + "L" +(w/2 - 6) + " " + (h/2)).attr(pathAttr);
        this.gSection.path( "M" + (w/2 + 5) + " " + (h/2 - 10) + "L" +(w/2 - 6) + " " + (h/2)).attr(pathAttr);
    }

    public getType(): string {
        return WfConstants.NODE_Gateway_Fork;
    }

    public newInstance(xmlNode: ITagNode): AbstractWfElement {
        return new ForkNode(xmlNode);
    }
}