import IGElement from "../../../../../../common/ui/graphic/IGElement";
import IGSection from "../../../../../../common/ui/graphic/IGSection";
import ITagNode from "../../../../../../common/xml/node/ITagNode";
import I18N from "../../../../base/i18n";
import WfConstants from "../../../../base/WfConstants";
import WfDefines from "../../../../base/WfDefines";
import AbstractWfElement from "../../AbstractWfElement";
import BaseCircleNode from "./BaseCircleNode";

export default class StateNode extends BaseCircleNode {

    constructor(xmlNode?: ITagNode) {
        super(xmlNode);
    }

    public getType(): string {
        return WfConstants.NODE_Event_State;
    }

    public drawGraphic(gSection: IGSection): IGElement {
        var r = this.getWidth() / 2;
        var group = gSection.section();
        var el1 = gSection.circle(r, r, r).attr({
            fill: '#fff',
            stroke: WfDefines.G_COLOR_STROKE_NORMAL,
            'fill-opacity': '0.1',
            'strokeWidth': 1
        });
        var el2 = gSection.circle(r, r, r / 2).attr({
            fill: '#fff',
            stroke: WfDefines.G_COLOR_STROKE_NORMAL,
            'fill-opacity': '0.1',
            'strokeWidth': 2
        });
        group.add(el1);
        group.add(el2);
        return group;
    }

    public newInstance(xmlNode: ITagNode): AbstractWfElement {
        return new StateNode(xmlNode);
    }
}