
import IGElement from "../../../../../../common/ui/graphic/IGElement";
import IGSection from "../../../../../../common/ui/graphic/IGSection";
import ITagNode from "../../../../../../common/xml/node/ITagNode";
import WfConstants from "../../../../base/WfConstants";
import WfDefines from "../../../../base/WfDefines";
import AbstractWfElement from "../../AbstractWfElement";
import BaseCircleNode from "./BaseCircleNode";

export default class BranchEndNode extends BaseCircleNode {

    constructor(xmlNode?: ITagNode) {
        super(xmlNode);
    }

    public drawGraphic(gSection: IGSection): IGElement {
        var r = this.getWidth() / 2;
        var el = gSection.circle(r, r, r).attr({
            fill: '#fff',
            stroke: WfDefines.G_COLOR_STROKE_NORMAL,
            'fill-opacity': '0.1',
            'strokeWidth': 4
        });
        return el;
    }

    public getType(): string {
        return WfConstants.NODE_Event_BranchEnd;
    }

    public newInstance(xmlNode: ITagNode): AbstractWfElement {
        return new BranchEndNode(xmlNode);
    }
}