import IGElement from "../../../../../../common/ui/graphic/IGElement";
import ITagNode from "../../../../../../common/xml/node/ITagNode";
import WfDefines from "../../../../base/WfDefines";
import AbstractNode from "../AbstractNode";

export default abstract class BaseCircleNode extends AbstractNode {

    constructor(xmlNode?: ITagNode) {
        super(xmlNode);
    }

    protected drawCaption(): IGElement {
        var bounds = this.getBounds();
        var caption = this.getCaption();
        var text = this.gSection.text(bounds.width / 2, bounds.height + 18, caption)
            .attr({'text-anchor': 'middle', 'font-size': 12});
        return text;
    }

    protected getWidth(): number {
        return WfDefines.G_CIRCLE_R * 2;
    }
    
    protected getHeight(): number {
        return WfDefines.G_CIRCLE_R * 2;
    }

    protected drawSymbo(): void{
    }
}