import IGElement from "../../../../../../common/ui/graphic/IGElement";
import IGSection from "../../../../../../common/ui/graphic/IGSection";
import ITagNode from "../../../../../../common/xml/node/ITagNode";
import WfDefines from "../../../../base/WfDefines";
import AbstractNode from "../AbstractNode";

export default abstract class BaseRectNode extends AbstractNode {

    constructor(xmlNode?: ITagNode) {
        super(xmlNode);
    }

    public drawGraphic(gSection: IGSection): IGElement {
        var el = gSection.rect(0, 0, this.getWidth(), this.getHeight(), WfDefines.G_RECT_R).attr({
            fill: '#fff',
            stroke: WfDefines.G_COLOR_STROKE_NORMAL,
            'fill-opacity': '0.1',
            'strokeWidth': 1
        });
        return el;
    }

    protected drawCaption(): IGElement | undefined {
        var bounds = this.getBounds();
        var caption = this.getCaption();
        var text = this.gSection.text(bounds.width / 2, bounds.height / 2 + 5, caption);
        text.attr({'text-anchor': 'middle', 'font-size': 12});
        return text;
    }

    protected getWidth(): number {
        return WfDefines.G_RECT_W;
    }

    protected getHeight(): number {
        return WfDefines.G_RECT_H;
    }
}