import IGElement from "../../../../../common/ui/graphic/IGElement";
import ITagNode from "../../../../../common/xml/node/ITagNode";
import TagNode from "../../../../../common/xml/node/TagNode";
import WfConstants from "../../../base/WfConstants";
import WfDefines from "../../../base/WfDefines";
import AbstractWfElement from "../AbstractWfElement";

export default abstract class AbstractNode extends AbstractWfElement {

    private selectedRect?: IGElement;

    private hoverRect?: IGElement;

    private optSymbo?: IGElement;

    // private gMenu?: GPopMenu;
    
    public markSelected(): void {
        this.markUnHovered();
        if (this.selectedRect) return;

        var bounds = this.getBounds();
        var selectRectX1 = -6, selectRectX2 = bounds.width + 12,
            selectRectY1 = -6, selectRectY2 = bounds.height + 12;
        this.selectedRect = this.gSection.rect(selectRectX1, selectRectY1, selectRectX2, selectRectY2).attr({
            fill: 'none',
            stroke: WfDefines.G_COLOR_STROKE_SELECT,
            'fill-opacity': '0.5',
            'strokeWidth': 1,
            'stroke-dasharray': '3,3'
        });

        selectRectX2 -= 8;
        selectRectY2 -= 8;
        var trianglestr = "M" + selectRectX2 + "," + selectRectY2 + " L"+ (selectRectX2 - 12) +","+ selectRectY2 + " L" + selectRectX2 + "," + (selectRectY2 - 12) + " L" + selectRectX2 + "," + selectRectY2;
        this.optSymbo = this.gSection.path(trianglestr).attr({ fill: WfDefines.G_COLOR_STROKE_SELECT, 'fill-opacity': '0.5'});

        this.optSymbo.hover((e) => this.optSymbo?.attr({'fill-opacity': '1'}), (e) => this.optSymbo?.attr({'fill-opacity': '0.5'}));

        this.optHandler && this.optSymbo.mousedown(this.optHandler);

        //this.gMenu = new GPopMenu(this.gSection.section(), bounds.width + 12, bounds.height + 12);
        //var gl = this.gMenu.addItem({key: "link", text: "连线"});
       //gl = this.gMenu.addItem({key: "delete", text: "删除"});
        
        /*this.gSection.circle(16, 16, 16).attr({
            fill: '#fff',
            stroke: WfDefines.G_COLOR_STROKE_NORMAL,
            'fill-opacity': '0.1',
            'strokeWidth': 1
        });*/
    }

    ensureGraphicTagNode(): ITagNode {
        var xmlGraphicNode = this.xmlNode.getChild(WfConstants.NODE_NodeGraphic);
        if (!xmlGraphicNode) {
            xmlGraphicNode = new TagNode(WfConstants.NODE_NodeGraphic);
            this.xmlNode.addChild(xmlGraphicNode);
        } 
        return xmlGraphicNode;
    }

    public getSelectSymbo(): IGElement | undefined {
        return this.selectedRect;
    }

    public markUnSelected(): void {
        this.markUnHovered();
        if (this.selectedRect) {
            this.selectedRect.remove();
            this.selectedRect = undefined;
        }
        if (this.optSymbo) {
            this.optSymbo.remove();
            this.optSymbo = undefined;
        }
        /*if (this.gMenu) {
            this.gMenu.getGSection().remove();
            this.gMenu = undefined;
        }*/
    }

    public markHovered(): void {
        if (this.isSelected()) return;
        var bounds = this.getBounds();
        this.hoverRect = this.gSection.rect(-6, -6, bounds.width + 12, bounds.height + 12).attr({
            fill: 'none',
            stroke: WfDefines.G_COLOR_STROKE_HOVER,
            'fill-opacity': '0.5',
            'strokeWidth': 1,
            'stroke-dasharray': '3,3'
        });
    }

    public markUnHovered(): void {
        if (this.isSelected()) return;
        if (this.hoverRect) {
            this.hoverRect.remove();
            this.hoverRect = undefined;
        }
    }
  
}