import WfConstants from "../base/WfConstants";
import SequenceFlow from "./element/link/SequenceFlow";
import AbstractWfElement from "./element/AbstractWfElement";
import AuditNode from "./element/node/activity/task/AuditNode";
import BeginNode from "./element/node/event/BeginNode";
import IGElement from "../../../common/ui/graphic/IGElement";
import IGSection from "../../../common/ui/graphic/IGSection";
import ITagNode from "../../../common/xml/node/ITagNode";
import TagNode from "../../../common/xml/node/TagNode";
import EndNode from "./element/node/event/EndNode";
import StateNode from "./element/node/event/StateNode";
import JoinNode from "./element/node/gateway/JoinNode";
import ForkNode from "./element/node/gateway/ForkNode";
import ExclusiveForkNode from "./element/node/gateway/ExclusiveForkNode";
import ComplexJoinNode from "./element/node/gateway/ComplexJoinNode";
import DecisionNode from "./element/node/gateway/DecisionNode";
import GatewayNode from "./element/node/gateway/GatewayNode";
import ServiceNode from "./element/node/activity/task/ServiceNode";
import ManualNode from "./element/node/activity/task/ManualNode";
import UserNode from "./element/node/activity/task/UserNode";
import DataMapNode from "./element/node/activity/task/DataMapNode";
import CounterSignNode from "./element/node/activity/task/CounterSignNode";
import MultiUserNode from "./element/node/activity/task/MultiUserNode";
import MultiAuditNode from "./element/node/activity/task/MultiAuditNode";
import StateActionNode from "./element/node/activity/task/StateActionNode";
import InlineProcessNode from "./element/node/activity/subprocess/InlineProcessNode";
import SubProcessNode from "./element/node/activity/subprocess/SubProcessNode";
import BranchEndNode from "./element/node/event/BranchEndNode";

export default class ViewElementFactory {

    private static instance: ViewElementFactory = new ViewElementFactory();

    private mapElements: Map<String, AbstractWfElement> = new Map();

    constructor() {
        this.mapElements.set(WfConstants.NODE_Flow_Sequence, new SequenceFlow());
        
        this.mapElements.set(WfConstants.NODE_Event_Begin, new BeginNode());
        this.mapElements.set(WfConstants.NODE_Event_BranchEnd, new BranchEndNode());
        this.mapElements.set(WfConstants.NODE_Event_End, new EndNode());
        this.mapElements.set(WfConstants.NODE_Event_State, new StateNode());

        this.mapElements.set(WfConstants.NODE_Gateway_GateWay, new GatewayNode());
        this.mapElements.set(WfConstants.NODE_Gateway_Join, new JoinNode());
        this.mapElements.set(WfConstants.NODE_Gateway_Fork, new ForkNode());
        this.mapElements.set(WfConstants.NODE_Gateway_ExclusiveFork, new ExclusiveForkNode());
        this.mapElements.set(WfConstants.NODE_Gateway_ComplexJoin, new ComplexJoinNode());
        this.mapElements.set(WfConstants.NODE_Gateway_Decision, new DecisionNode());

        this.mapElements.set(WfConstants.NODE_Task_Audit, new AuditNode());
        this.mapElements.set(WfConstants.NODE_Task_Service, new ServiceNode());
        this.mapElements.set(WfConstants.NODE_Task_Manual, new ManualNode());
        this.mapElements.set(WfConstants.NODE_Task_User, new UserNode());
        this.mapElements.set(WfConstants.NODE_Task_DataMap, new DataMapNode());
        this.mapElements.set(WfConstants.NODE_Task_CounterSign, new CounterSignNode());
        this.mapElements.set(WfConstants.NODE_Task_MultiUser, new MultiUserNode());
        this.mapElements.set(WfConstants.NODE_Task_MultiAudit, new MultiAuditNode());
        this.mapElements.set(WfConstants.NODE_Task_StateAction, new StateActionNode());

        this.mapElements.set(WfConstants.NODE_Inline, new InlineProcessNode());
        this.mapElements.set(WfConstants.NODE_SubProcess, new SubProcessNode());
    }

    get(tag: string): AbstractWfElement | undefined {
        return this.mapElements.get(tag);
    }

    public static create(xmlNode: ITagNode): AbstractWfElement | undefined {
        return ViewElementFactory.instance.get(xmlNode.getTagName())?.newInstance(xmlNode);
    }

    public static createShadowGraphic(tag: string, gSection: IGSection): IGElement | undefined {
        var xmlNode = new TagNode(tag);
        return ViewElementFactory.instance.get(tag)?.newInstance(xmlNode).drawGraphic(gSection);
    }
}