import GlobalConstants from "../../../common/struct/GlobalConstants";
import ITagNode from "../../../common/xml/node/ITagNode";


export default class WfTagNodeUtil {

    static getOperationAction(tagNode: ITagNode): string {
        var tmpNode = tagNode.getChild(GlobalConstants.S_Action);
        return tmpNode ? tmpNode.getCDATAValue() : "";
    }

    static getParticipatorFormula(tagNode: ITagNode): string {
        if (tagNode.getTagName() == GlobalConstants.S_MidFormula
            || tagNode.getTagName() == GlobalConstants.S_Query) {
            return tagNode.getCDATAValue();
        } else {
            return "";
        }
        
    }
}