import RectBound from "../../../../common/struct/RectBound";
import IGElement from "../../../../common/ui/graphic/IGElement";
import WfConstants from "../../base/WfConstants";
import WfDefines from "../../base/WfDefines";
import AbstractWfElement from "../../view/element/AbstractWfElement";
import AbstractLink from "../../view/element/link/AbstractLink";

export default class ShadowLink extends AbstractLink {

    private shadowLine: IGElement | undefined;

    private static style = {stroke: WfDefines.G_COLOR_STROKE_NORMAL, 'fill-opacity': '0.5', 'strokeWidth': 1, 'stroke-dasharray': '5,3'};

    constructor() {
        super();
    }

    public drawGraphic(): IGElement {
        this.shadowLine = this.gSection.path("");
        return this.shadowLine;
    }

    public drawShadowToLink(toRect: RectBound): void {
        if (this.fromNode) {
            var pos = this.getPos(this.fromNode.getBounds(), toRect);
            this.shadowLine && this.shadowLine.attr({"path": pos.linestr}).attr(ShadowLink.style);
        }
    }

    public drawShadowFromLink(fromRect: RectBound): void {
        if (this.toNode) {
            var pos = this.getPos(fromRect, this.toNode.getBounds());
            this.shadowLine && this.shadowLine.attr({"path": pos.linestr}).attr(ShadowLink.style);
        }
    }
    
    public getType(): string {
        return WfConstants.NODE_Flow_Sequence;
    }

    protected getDefaultCaption(): string {
        return '';
    }

    public newInstance(): AbstractWfElement {
        return new ShadowLink();
    }

}