import AbstractOptState from "../../../common/state/AbstractOptState";
import WfGraphicView from "../view/WfGraphicView";
import AbstractWfOptState from "./AbstractWfOptState";
import OptStateDelegate from "./OptStateDelegate";

export default class UnableOptState extends AbstractWfOptState {

    constructor(view: WfGraphicView, delegate: OptStateDelegate) {
        super(view, delegate);
    }

    dragstart(x: number, y: number, event: MouseEvent): void {
    }

    dragmove(dx: number, dy: number, x: number, y: number, event: MouseEvent): void {
    }

    dragend(event: MouseEvent): void {
    }

    mousedown(e: MouseEvent): void {
        var el = <HTMLElement> e.target;
        var node = this.view.hitHtmlElement(el);
        this.view.unSelectAllDenyFlows();
        this.view.getSelectionModel().select(node?.getTagNode());
    }

    mousemove(e: MouseEvent): void {
    }
    
    mouseup(e: MouseEvent): void {
    }
}