import AbstractOptStateDelegate from "../../../common/state/AbstractOptStateDelegate";
import AbstractLink from "../view/element/link/AbstractLink";
import AbstractNode from "../view/element/node/AbstractNode";
import WfGraphicView from "../view/WfGraphicView";
import ChangeLineFormNodeState from "./ChangeLineFromNodeState";
import ChangeLineToNodeState from "./ChangeLineToNodeState";
import NewLinkAndNodeState from "./NewLinkAndNodeState";
import NewLinkState from "./NewLinkState";
import NewNodeState from "./NewNodeState";
import NormalState from "./NormalState";
import OptOnLineState from "./OptOnLineState";
import UnableOptState from "./UnableOptState";

export default class OptStateDelegate extends AbstractOptStateDelegate<WfGraphicView> {

    private normalState: NormalState;

    private newNodeState: NewNodeState;

    private newLinkState: NewLinkState;

    private newLinkAndNodeState: NewLinkAndNodeState;

    private changeLineFromNodeState: ChangeLineFormNodeState;

    private changeLineToNodeState: ChangeLineToNodeState;

    private unableState: UnableOptState;

    // 线上加号标志操作
    private optOnLineState: OptOnLineState;

    constructor(view: WfGraphicView) {
        super(view);
        this.normalState = new NormalState(view, this);
        this.setInitState(this.normalState);
        this.newNodeState = new NewNodeState(view, this);
        this.newLinkState = new NewLinkState(view, this);
        this.newLinkAndNodeState = new NewLinkAndNodeState(view, this);
        this.changeLineFromNodeState = new ChangeLineFormNodeState(view, this);
        this.changeLineToNodeState = new ChangeLineToNodeState(view, this);
        this.optOnLineState = new OptOnLineState(view, this);
        this.unableState = new UnableOptState(view, this);
    }

    public setNewNodeState(type: string) {
        this.newNodeState.setType(type);
        this.setCurrentState(this.newNodeState);
    }

    public setNewLinkAndNodeState(fromNode: AbstractNode, toNodeType: string, linkType: string): void {
        this.newLinkAndNodeState.setToNodeType(toNodeType);
        this.newLinkAndNodeState.setLinkType(linkType);
        this.newLinkAndNodeState.setFromNode(fromNode);
        this.setCurrentState(this.newLinkAndNodeState);
    }

    public setNewLinkState(type: string): NewLinkState {
        this.newLinkState.setType(type);
        this.setCurrentState(this.newLinkState);
        return this.newLinkState;
    }

    public setChangeLineFromNodeState(link: AbstractLink) {
        this.changeLineFromNodeState.setLink(link);
        this.setCurrentState(this.changeLineFromNodeState);
    }

    public setChangeLineToNodeState(link: AbstractLink) {
        this.changeLineToNodeState.setLink(link);
        this.setCurrentState(this.changeLineToNodeState);
    }

    public setOptOnLineState(link: AbstractLink) {
        this.optOnLineState.setLink(link);
        this.setCurrentState(this.optOnLineState);
    }

    public setUnableState(): void {
        this.setCurrentState(this.unableState);
    }
}