import AbstractDomElement from "../../../../../common/dom/AbstractDomElement";
import IXElement from "../../../../../common/dom/xelement/IXElement";
import { ESizeType } from "../../../../../common/enum/Enums";
import IView from "../../../../../common/interfaces/IView";
import OperationDispatcher from "../../../../../common/operation/OperationDispatcher";
import SizeInfo from "../../../../../common/struct/SizeInfo";
import { IPropertyGroup, IPropertyIO } from "../../../../plugin/property/base/PropertyDefine";
import PropertyUIPanel from "../../../../plugin/property/ui/PropertyUIPanel";

export default class PermPropertyView implements IView {

    private propertyPanel: PropertyUIPanel;

    constructor(groups: IPropertyGroup[], callback: IPropertyIO, optDispatcher: OperationDispatcher) {
        this.propertyPanel = new PropertyUIPanel(groups, callback, optDispatcher);
        this.propertyPanel.setStyle("border", "none");
    }

    focus(el: IXElement): void {
    }
    
    unfocus(): void {
    }

    display(parent: AbstractDomElement): void {
        parent.addChild(this.propertyPanel);
    }

    undisplay(parent: AbstractDomElement): void {
        parent.removeChild(this.propertyPanel);
    }

    resize(width: SizeInfo, height: SizeInfo): void {
        if (width.getType() == ESizeType.px && height.getType() == ESizeType.px) {
            this.propertyPanel.resize(width.getValue(), height.getValue());
        }
    }

}