import AbstractDomElement from "../../../../../common/dom/AbstractDomElement";
import IXElement from "../../../../../common/dom/xelement/IXElement";
import IView from "../../../../../common/interfaces/IView";
import OperationDispatcher from "../../../../../common/operation/OperationDispatcher";
import SizeInfo from "../../../../../common/struct/SizeInfo";
import IPropertyItem, { IPropertyIO } from "../../../../plugin/property/base/PropertyDefine";
import ParticipatorUIGroup from "../ParticipatorUIGroup";

export default class ParticipatorPropertyView implements IView {

    private participatorUIGroup: ParticipatorUIGroup;

    private participatorProperty: IPropertyItem;
    private callback: IPropertyIO;

    constructor(operationDispatcher: OperationDispatcher, participatorProperty: IPropertyItem, callback: IPropertyIO) {
        this.participatorUIGroup = new ParticipatorUIGroup(operationDispatcher);
        this.participatorProperty = participatorProperty;
        this.callback = callback;
    }

    focus(el: IXElement): void {
    }

    unfocus(): void {
    }

    display(parentDomElement: AbstractDomElement, width: SizeInfo, height: SizeInfo): void {
        this.loadProperty(this.participatorProperty, this.callback);
        parentDomElement.addChild(this.participatorUIGroup);
    }

    undisplay(parentEl: AbstractDomElement): void {
        parentEl.removeChild(this.participatorUIGroup);
    }

    resize(width: SizeInfo, height: SizeInfo): void {
    }

    private loadProperty(participatorProperty: IPropertyItem, callback: IPropertyIO) {
        this.participatorUIGroup.loadProperty(participatorProperty, callback);
    }
}