import ControlFactory from "../../../../../common/component/factory/ControlFactory";
import AbstractDomElement from "../../../../../common/dom/AbstractDomElement";
import IXElement from "../../../../../common/dom/xelement/IXElement";
import { ESizeType } from "../../../../../common/enum/Enums";
import IView from "../../../../../common/interfaces/IView";
import OperationDispatcher from "../../../../../common/operation/OperationDispatcher";
import GlobalConstants from "../../../../../common/struct/GlobalConstants";
import SizeInfo from "../../../../../common/struct/SizeInfo";
import TagNode from "../../../../../common/xml/node/TagNode";
import YigoGrid from "../../../../../yiui/design/control/YigoGrid";
import IPropertyItem, {IPropertyIO } from "../../../../plugin/property/base/PropertyDefine";
import WfTagNodeUtil from "../../../util/WfTagNodeUtil";

export default class OperationPropertyView implements IView {

    private grid?: YigoGrid;

    private operationProperty!: IPropertyItem;

    private callback!: IPropertyIO;

    private operationDispatcher: OperationDispatcher;

    constructor(operationDispatcher: OperationDispatcher, operationProperty: IPropertyItem, callback: IPropertyIO) {
        this.operationDispatcher = operationDispatcher;
        this.operationProperty = operationProperty;
        this.callback = callback;
    }

    async fillDataToGrid(collection: any, grid:YigoGrid): Promise<void> {
        var row = 0;
        var optDispatcher = this.operationDispatcher;
        for (let node of collection.getChildren()) {
            if (node instanceof TagNode) {
                var tagNode = <TagNode> node;
                var action = WfTagNodeUtil.getOperationAction(tagNode);
                var id = await optDispatcher.queryFormulaDictID(action);
                await grid.setValueAt(row, 0, id);
                await grid.setValueAt(row, 1, action);
                await grid.setValueAt(row, 2, tagNode.toXml(true));
                row = await grid.insertRow(-1);
            }
        }
    }

    focus(el: IXElement): void {
    }

    unfocus(): void {
    }

    display(parentDomElement: AbstractDomElement) {
        this.loadProperty(this.operationProperty, this.callback).then(optGrid => {
            this.grid = optGrid;
            optGrid && parentDomElement.addChild(optGrid.getDomElement());
        })
    }

    undisplay(parentEl: AbstractDomElement) {
        this.grid && parentEl.removeChild(this.grid.getDomElement());
    }

    resize(width: SizeInfo, height: SizeInfo): void {
        if (!this.grid) return;
        if (width.getType() == ESizeType.px && height.getType() == ESizeType.px) {
            this.grid.$el.width(width.getValue());
            this.grid.$el.height(height.getValue());
        }
    }

    private async loadProperty(operationProperty: IPropertyItem, callback: IPropertyIO) {
        this.operationProperty = operationProperty;
        this.callback = callback;
        const optGrid = await ControlFactory.getPropertyGrid(GlobalConstants.S_Operation, this.operationDispatcher);
        if (!optGrid)
            return;
        var collection = this.callback.getValue(this.operationProperty);
        this.fillDataToGrid(collection, optGrid);
        return optGrid;
    }
}