import AbstractDomElement from "../../../../../common/dom/AbstractDomElement";
import IXElement from "../../../../../common/dom/xelement/IXElement";
import { ESizeType } from "../../../../../common/enum/Enums";
import IView from "../../../../../common/interfaces/IView";
import OperationDispatcher from "../../../../../common/operation/OperationDispatcher";
import SizeInfo from "../../../../../common/struct/SizeInfo";
import { IPropertyGroup, IPropertyIO } from "../../../../plugin/property/base/PropertyDefine";
import PropertyUIPanel from "../../../../plugin/property/ui/PropertyUIPanel";

export default class BasePropertyView implements IView {

    private propertyPanel: PropertyUIPanel;

    constructor(groups: IPropertyGroup[], callback: IPropertyIO, optDispatcher: OperationDispatcher) {
        this.propertyPanel = new PropertyUIPanel(groups, callback, optDispatcher);
        this.propertyPanel.setStyle("border", "none");
    }

    setPropertyValue(key: string, value: any, text?: string): void {
        this.propertyPanel.setPropertyValue(key, value, text);
    }

    setFocus(key: string): void {
        this.propertyPanel.setFocus(key);
    }

    display(parent: AbstractDomElement): void {
        parent.addChild(this.propertyPanel);
    }

    focus(el: IXElement): void {
        this.propertyPanel.focus(el.getHtmlElement());
    }

    unfocus(): void {
        this.propertyPanel.unfocus();
    }

    undisplay(parent: AbstractDomElement): void {
        parent.removeChild(this.propertyPanel);
    }

    resize(width: SizeInfo, height: SizeInfo): void {
        if (width.getType() == ESizeType.px && height.getType() == ESizeType.px) {
            this.propertyPanel.setStyleWidth(width);
            this.propertyPanel.setStyleHeight(height);
            this.propertyPanel.resize(width.getValue(), height.getValue());
        }
    }

}