import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import IEventListener from "../../../../common/listener/IEventListener";
import Paras from "../../../../common/struct/Paras";
import Events from "../../../../common/event/Events";
import IPropertyItem, { IPropertyIO } from "../../../plugin/property/base/PropertyDefine";
import ParticipatorUIGroupItem from "./ParticipatorUIGroupItem";
import ControlFactory from "../../../../common/component/factory/ControlFactory";
import GlobalConstants from "../../../../common/struct/GlobalConstants";
import TagNode from "../../../../common/xml/node/TagNode";
import OperationDispatcher from "../../../../common/operation/OperationDispatcher";
import WfTagNodeUtil from "../../util/WfTagNodeUtil";
import YigoGrid from "../../../../yiui/design/control/YigoGrid";

export default class ParticipatorUIGroup extends AbstractDomElement implements IEventListener {

    //private gridRole?: YigoGrid;

    //private gridOperator?: YigoGrid;

    //private gridParticipator?: YigoGrid;

    private participatorProperty!: IPropertyItem;

    private callback!: IPropertyIO;

    private optDispatcher: OperationDispatcher;

    constructor(operationDispatcher: OperationDispatcher) {
        super();
        this.optDispatcher = operationDispatcher;
        this.addClassArray(this.styleFactory.getPropertyPanel());
        //this.init(participatorProperty, callback);
    }

    loadProperty(participatorProperty: IPropertyItem, callback: IPropertyIO) {
        this.clearChildren();
        this.participatorProperty = participatorProperty;
        this.callback = callback;
        ControlFactory.getPropertyGrid(GlobalConstants.S_Operator, this.optDispatcher).then((gridOperator) => {
            if (gridOperator) {
                var uiGroup: ParticipatorUIGroupItem = new ParticipatorUIGroupItem("操作员选择", true, gridOperator , callback);
                this.addChild(uiGroup);
                uiGroup.setOnEventListener(this);
                this.initDictoryGrid(gridOperator, 'Operator');
            }
        });
        ControlFactory.getPropertyGrid(GlobalConstants.S_Role, this.optDispatcher).then((gridRole) => {
            if (gridRole) {
                var uiGroup = new ParticipatorUIGroupItem("角色选择", true, gridRole, callback);
                this.addChild(uiGroup);
                uiGroup.setOnEventListener(this);
                this.initDictoryGrid(gridRole, 'Role');
            }
        });
        ControlFactory.getPropertyGrid(GlobalConstants.S_Participator, this.optDispatcher).then((gridParticipator) => {
            if (gridParticipator) {
                var uiGroup = new ParticipatorUIGroupItem("自定义参与者", true, gridParticipator, callback);
                this.addChild(uiGroup);
                uiGroup.setOnEventListener(this);
                this.initParticipatorGrid(gridParticipator);
            }
        });
    }

    notifyEvent(cmd: string, paras: Paras): void {
        switch (cmd) {
            case Events.Focus:
                this.focus(paras.getElement());
                break;
        }
    }

    focus(el: HTMLElement): void {
    }

    unfocus(): void {
    }

    clearRows(): void {
        //this.gridRole && this.gridRole.clearRows();
        //this.gridOperator && this.gridOperator.clearRows();
        //this.gridParticipator && this.gridParticipator.clearRows();
    }

    private async initDictoryGrid(grid: YigoGrid, gridItemKey: string) {
        var row = 0;
        var collection = this.callback.getValue(this.participatorProperty);
        for (let node of collection.getChildren()) {
            if (node.getTagName() == GlobalConstants.S_Dictionary) {
                var tagNode = <TagNode> node;
                var itemKey = tagNode.getAttributeValue(GlobalConstants.S_ItemKey);
                if (gridItemKey == itemKey) {
                    var itemIDs = tagNode.getAttributeValue(GlobalConstants.S_ItemID);
                    if (itemIDs) {
                        var ids = String(itemIDs);
                        var arrItemIDs =  ids.split(":");
                        for (let id of arrItemIDs) {
                            var dictID = parseInt(id);
                            if (dictID > 0) {
                                await grid.setValueAt(row, 0, dictID);
                                row = await grid.insertRow(-1);
                            }
                        }
                    }
                    
                    var itemCodes = tagNode.getAttributeValue(GlobalConstants.S_Code);
                    if (itemCodes) {
                        var codes = String(itemCodes);
                        var arrItemCodes =  codes.split(":");
                        for (let code of arrItemCodes) {
                            var dictID = await this.optDispatcher.queryDictID(itemKey, code)
                            if (dictID > 0) {
                                await grid.setValueAt(row, 0, dictID);
                                row = await grid.insertRow(-1);
                            }
                        }
                    }
                }
            }
        }
    }

    private async initParticipatorGrid(participatorGrid: YigoGrid) {
        var row = 0;
        var collection = this.callback.getValue(this.participatorProperty);
        for (let node of collection.getChildren()) {
            if (node.getTagName() == GlobalConstants.S_MidFormula
                || node.getTagName() == GlobalConstants.S_Query) {
                var tagNode = <TagNode> node;
                var formula = WfTagNodeUtil.getParticipatorFormula(tagNode);
                var id = await this.optDispatcher.queryFormulaDictID(formula);
                await participatorGrid.setValueAt(row, 0, id);
                await participatorGrid.setValueAt(row, 1, formula);
                await participatorGrid.setValueAt(row, 2, tagNode.toXml(true));
                row = await participatorGrid.insertRow(-1);
            }
        }
    }

    resize(width:number, height:number) {
        for( let child of this.getChildren()) {
            child.resize(width, height);
        }
    }
}
