import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import SizeInfo from "../../../common/struct/SizeInfo";
import { IPropertyGroup, IPropertyIO, IPropertyPlugin } from "../../plugin/property/base/PropertyDefine";
import BPMPropertyUIPanel from "./ui/BPMPropertyUIPanel";

export default class BPMPropertyPlugin implements IPropertyPlugin {

    private propertyPanel?: BPMPropertyUIPanel;

    private mapProperties: any = {};

    private operationDispatcher: OperationDispatcher;

    constructor(operationDispatcher: OperationDispatcher) {
        this.operationDispatcher = operationDispatcher;
    }

    setFocus(key: string): void {
         this.propertyPanel?.setFocus(key);
    }

    setPropertyValue(key: string, value: any, text?: string | undefined): void {
         this.propertyPanel?.setPropertyValue(key, value, text);
    }

    register(componentName: string, propertyDefine: IPropertyGroup[]): void {
        this.mapProperties[componentName] = propertyDefine;
    }

    getPropertyGroupArray(componentName: string) : IPropertyGroup[] {
        return this.mapProperties[componentName];
    }

    commit(): void {
        if (this.propertyPanel) {
            this.propertyPanel.unfocus();
        }
    }

    display(componentName: string, callback: IPropertyIO, parent: HTMLElement) {
        this.propertyPanel && parent.removeChild(this.propertyPanel.getEl());
        this.propertyPanel = undefined;
        /*var len = parent.childNodes.length;
        for (var i=len-1; i>=0; i--){
            var child = parent.childNodes[i];
            if (child.nodeType == 1) {
                parent.removeChild(child);
            }
        }*/
        var propertyGroups: IPropertyGroup[] = this.getPropertyGroupArray(componentName);
        var tmpPropertyPanel = new BPMPropertyUIPanel(this.operationDispatcher);
        tmpPropertyPanel.loadProperty(propertyGroups, callback);
        parent.appendChild(tmpPropertyPanel.getEl());
        tmpPropertyPanel.display(SizeInfo.valueOfPX(parent.clientWidth), SizeInfo.valueOfPX(parent.clientWidth));
        tmpPropertyPanel.resize(parent.clientWidth, parent.clientHeight);
        this.propertyPanel = tmpPropertyPanel;
        window.addEventListener("resize", (e: any) => {
            this.propertyPanel?.resize(parent.clientWidth, parent.clientHeight);
        });
    }
}
