import ICmd from "../../../common/cmd/ICmd";
import GlobalConstants from "../../../common/struct/GlobalConstants";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import I18N from "../base/I18N";
import WfConstants from "../base/WfConstants";

export default class NewLinkCmd implements ICmd {

    private type: string;

    private fromTag!: ITagNode;

    private id: string;

    private xmlEntity: IXmlEntity;

    private tagLink?: ITagNode;

    private toNodeKey: string;


    constructor(xmlEntity: IXmlEntity, id: number, type: string, fromTag: ITagNode, toNodeKey: string) {
        this.xmlEntity = xmlEntity;
        this.id = String(id);
        this.type = type;
        this.fromTag = fromTag;
        this.toNodeKey = toNodeKey;
    }

    do(): boolean {
        if (this.toNodeKey == this.fromTag.getAttributeValue("Key")) {
            return false;
        }
        this.tagLink = this.xmlEntity.getNodeFactory().createTagNode(this.type);
        this.tagLink.setAttributeValue(GlobalConstants.S_ID, this.id);
        this.tagLink.setAttributeValue(GlobalConstants.S_Key, this.type + GlobalConstants.SP_KEY + this.id);
        this.tagLink.setAttributeValue(GlobalConstants.S_Caption, I18N.getString(this.type));
        this.tagLink.setAttributeValue(WfConstants.ATTR_TargetNodeKey, this.toNodeKey);
        var tagCollection =  this.xmlEntity.ensureNode(WfConstants.NODE_TransitionCollection, this.fromTag); 
        this.xmlEntity.addNode(this.tagLink, tagCollection);
        return true;
    }

    undo(): void {
        this.tagLink && this.xmlEntity.removeNode(this.tagLink);
    }

}