import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import WfConstants from "../base/WfConstants";
import WfDefines from "../base/WfDefines";
import WfGraphicView from "../view/WfGraphicView";


export default class MoveNodeCmd implements ICmd {

    private offsetX: number = 0;

    private offsetY: number = 0;

    //private nodes: ISelectable[];

    private nodes: ITagNode[];

    private view: WfGraphicView;

    private oldX: number = -1;
    private oldY: number = -1;

    constructor(view: WfGraphicView, offsetX: number, offsetY: number) {
        this.view = view;
        this.nodes = view.getSelectionModel().doCacheTagNodes4Node();
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    do(): boolean {
        var xmlEntity = this.view.getXmlEntity();
        if (!xmlEntity) return false;
        for (let node of this.nodes) {
            if(node.getTagName() == WfConstants.NODE_Flow_Sequence){
                continue;
             }
            var nodeGraphic = xmlEntity.ensureNode(WfConstants.NODE_NodeGraphic, node);

            this.oldX = nodeGraphic.getAttributeValueInt(WfConstants.ATTR_X, 0);
            this.oldY = nodeGraphic.getAttributeValueInt(WfConstants.ATTR_Y, 0);
            var x = this.oldX + this.offsetX;
            var y = this.oldY + this.offsetY;

            if (x < 10) x = 10;
            if (y < 10) y = 10;
            if (x > (WfDefines.PAPER_W - 10)) x = WfDefines.PAPER_W - 10;
            if (y > (WfDefines.PAPER_H - 10)) y = WfDefines.PAPER_H - 10;

            nodeGraphic.setAttributeValue(WfConstants.ATTR_X, String(x));
            nodeGraphic.setAttributeValue(WfConstants.ATTR_Y, String(y));
            xmlEntity.update(node, false);
        }
        /*for (let node of this.nodes) {
            if (node instanceof AbstractNode) {
                (<AbstractWfElement> node).setLocation(node.getX() + this.offsetX, node.getY() + this.offsetY);
                this.view.updateLinkByNode(<AbstractNode> node);
            }
        }*/
        return true;
    }

    undo(): void {
        var xmlEntity = this.view.getXmlEntity();
        if (!xmlEntity) return;
        for (let node of this.nodes) {
            if(node.getTagName() == WfConstants.NODE_Flow_Sequence){
                continue;
             }
            var nodeGraphic = xmlEntity.ensureNode(WfConstants.NODE_NodeGraphic, node);
            this.oldX > -1 && nodeGraphic.setAttributeValue(WfConstants.ATTR_X, String(this.oldX));
            this.oldY > -1 && nodeGraphic.setAttributeValue(WfConstants.ATTR_Y, String(this.oldY));
            xmlEntity.update(node, false);
        }

        /*for (let node of this.nodes) {
            if (node instanceof AbstractNode) {
                (<AbstractWfElement> node).setLocation(node.getX() - this.offsetX, node.getY() - this.offsetY);
                this.view.updateLinkByNode(<AbstractNode> node);
            }
        }*/
    }

}